/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonWriter {
    private final int indent_;
    private final String spc_;
    private static final String[] ctrlStrs = new String[]{"\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\b", "\\t", "\\n", "\\u000b", "\\f", "\\r", "\\u000e", "\\u000f", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001a", "\\u001b", "\\u001c", "\\u001d", "\\u001e", "\\u001f"};

    public JsonWriter() {
        this(2, true);
    }

    public JsonWriter(int indent, boolean spacer) {
        this.indent_ = indent;
        this.spc_ = spacer ? " " : "";
    }

    public String toJson(Object item) {
        StringBuffer sbuf = new StringBuffer();
        this.toJson(sbuf, item, 0, false);
        if (this.indent_ >= 0) {
            assert (sbuf.charAt(0) == '\n');
            return sbuf.substring(1, sbuf.length());
        }
        return sbuf.toString();
    }

    public void toJson(StringBuffer sbuf, Object item, int level, boolean isPositioned) {
        if (item instanceof List) {
            List list = (List)item;
            if (list.isEmpty()) {
                if (!isPositioned) {
                    sbuf.append(this.getIndent(level));
                }
                sbuf.append("[]");
            } else {
                sbuf.append(this.getIntroIndent(level, '[', isPositioned));
                boolean isPos = !isPositioned;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.toJson(sbuf, it.next(), level + 1, isPos);
                    if (it.hasNext()) {
                        sbuf.append(",");
                    }
                    isPos = false;
                }
                sbuf.append(this.spc_ + "]");
            }
        } else if (item instanceof Map) {
            Map map = (Map)item;
            if (map.isEmpty()) {
                if (!isPositioned) {
                    sbuf.append(this.getIndent(level));
                }
                sbuf.append("{}");
            } else {
                sbuf.append(this.getIntroIndent(level, '{', isPositioned));
                boolean isPos = !isPositioned;
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = map.get(key);
                    sbuf.append(this.jsonPair(key.toString(), value, level + 1, isPos));
                    if (it.hasNext()) {
                        sbuf.append(",");
                    }
                    isPos = false;
                }
                sbuf.append(this.spc_ + "}");
            }
        } else {
            if (!isPositioned) {
                sbuf.append(this.getIndent(level));
            }
            sbuf.append(this.jsonScalar(item));
        }
    }

    public String getIndent(int level) {
        if (this.indent_ >= 0) {
            int nc = level * this.indent_;
            StringBuffer sbuf = new StringBuffer(nc + 1);
            sbuf.append('\n');
            for (int ic = 0; ic < nc; ++ic) {
                sbuf.append(' ');
            }
            return sbuf.toString();
        }
        return "";
    }

    private String jsonString(Object item) {
        String str = item == null ? "" : item.toString();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            sbuf.append(this.jsonChar(str.charAt(i)));
        }
        sbuf.append('\"');
        return sbuf.toString();
    }

    public String jsonPair(String key, Object value, int level, boolean isPositioned) {
        StringBuffer sbuf = new StringBuffer();
        this.toJson(sbuf, key, level, isPositioned);
        sbuf.append(":" + this.spc_);
        this.toJson(sbuf, value, level, true);
        return sbuf.toString();
    }

    private String jsonScalar(Object item) {
        if (item == null) {
            return "null";
        }
        if (item instanceof Boolean || item instanceof Number) {
            return item.toString();
        }
        return this.jsonString(item);
    }

    private String jsonChar(char c) {
        if (c < ' ') {
            return ctrlStrs[c];
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\\') {
            return "\\\\";
        }
        return Character.toString(c);
    }

    private String getIntroIndent(int level, char chr, boolean isPositioned) {
        if (isPositioned) {
            return new StringBuffer().append(chr).toString();
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getIndent(level));
        sbuf.append(chr);
        for (int ic = 0; ic < this.indent_ - 1; ++ic) {
            sbuf.append(' ');
        }
        return sbuf.toString();
    }
}

