/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.util.HashMap;
import java.util.Map;

public enum ReportType {
    ERROR('E', "Error", "Errors", "Error in operation or standard compliance of the service."),
    WARNING('W', "Warning", "Warnings", "Warning that service behaviour is questionable, or contravenes a standard recommendation, but is not in actual violation of the standard."),
    INFO('I', "Info", "Infos", "Information about progress, for instance details of queries made."),
    SUMMARY('S', "Summary", "Summaries", "Summary of previous successful/unsuccessful reports."),
    FAILURE('F', "Failure", "Failures", "Failure of the validator to perform some testing. The cause is either some error internal to the validator, or some error or missing functionality in the service which has already been reported.");

    private final char chr_;
    private final String name_;
    private final String names_;
    private final String description_;
    private static Map<Character, ReportType> charMap_;

    private ReportType(char chr, String name, String names, String description) {
        this.chr_ = chr;
        this.name_ = name;
        this.names_ = names;
        this.description_ = description;
    }

    public char getChar() {
        return this.chr_;
    }

    public String getName() {
        return this.name_;
    }

    public String getNames() {
        return this.names_;
    }

    public String getDescription() {
        return this.description_;
    }

    public static ReportType forChar(char chr) {
        if (charMap_ == null) {
            HashMap<Character, ReportType> map = new HashMap<Character, ReportType>();
            ReportType[] types = ReportType.values();
            for (int i = 0; i < types.length; ++i) {
                ReportType type = types[i];
                map.put(Character.valueOf(Character.toUpperCase(type.getChar())), type);
            }
            charMap_ = map;
        }
        return charMap_.get(Character.valueOf(Character.toUpperCase(chr)));
    }
}

