/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.CapabilityStage;
import uk.ac.starlink.ttools.taplint.ColumnMetadataStage;
import uk.ac.starlink.ttools.taplint.CompareMetadataStage;
import uk.ac.starlink.ttools.taplint.EpnTapStage;
import uk.ac.starlink.ttools.taplint.ExampleStage;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.JobStage;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ObsLocStage;
import uk.ac.starlink.ttools.taplint.ObsTapStage;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.QueryStage;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TableMetadataStage;
import uk.ac.starlink.ttools.taplint.TablesEndpointStage;
import uk.ac.starlink.ttools.taplint.TapSchemaMetadataHolder;
import uk.ac.starlink.ttools.taplint.TapSchemaStage;
import uk.ac.starlink.ttools.taplint.UnitUcdStage;
import uk.ac.starlink.ttools.taplint.UploadStage;
import uk.ac.starlink.ttools.taplint.VotLintTapRunner;
import uk.ac.starlink.ttools.taplint.XsdStage;
import uk.ac.starlink.util.IOSupplier;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.StdCapabilityInterface;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapabilitiesDoc;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.UserAgentUtil;

public class TapLinter {
    private final StageSet stageSet_;
    private final XsdStage tmetaXsdStage_;
    private final TablesEndpointStage tmetaStage_;
    private final TapSchemaStage tapSchemaStage_;
    private final CompareMetadataStage cfTmetaStage_;
    private final UnitUcdStage unitUcdStage_;
    private final XsdStage tcapXsdStage_;
    private final CapabilityStage tcapStage_;
    private final XsdStage availXsdStage_;
    private final QueryStage getQueryStage_;
    private final QueryStage postQueryStage_;
    private final QueryStage asyncQueryStage_;
    private final JobStage jobStage_;
    private final ColumnMetadataStage colMetaStage_;
    private final UploadStage uploadStage_;
    private final ObsTapStage obstapStage_;
    private final ObsLocStage obslocStage_;
    private final EpnTapStage epntapStage_;
    private final ExampleStage exampleStage_;
    private final TapSchemaMetadataHolder tapSchemaMetadata_;
    private final CapabilitiesReader capabilitiesReader_ = new CapabilitiesReader();
    public static final String MDQ_NAME = "MDQ";

    public TapLinter() {
        this.tmetaXsdStage_ = new XsdStage("http://www.ivoa.net/xml/VODataService/v1.1", "tableset", false, "table metadata"){

            @Override
            public URL getDocumentUrl(TapService tapService) {
                return tapService.getTablesEndpoint();
            }
        };
        this.tmetaStage_ = new TablesEndpointStage(this.capabilitiesReader_);
        this.tapSchemaStage_ = new TapSchemaStage(VotLintTapRunner.createGetSyncRunner(true));
        this.tapSchemaMetadata_ = new TapSchemaMetadataHolder();
        AnyMetadataHolder metaHolder = new AnyMetadataHolder(new MetadataHolder[]{this.tapSchemaStage_, this.tmetaStage_, this.tapSchemaMetadata_});
        AnyMetadataHolder declaredMetaHolder = new AnyMetadataHolder(new MetadataHolder[]{this.tapSchemaStage_, this.tmetaStage_});
        this.cfTmetaStage_ = CompareMetadataStage.createStage(this.tmetaStage_, this.tapSchemaStage_);
        this.unitUcdStage_ = new UnitUcdStage(declaredMetaHolder);
        this.tcapXsdStage_ = new XsdStage("http://www.ivoa.net/xml/VOSICapabilities/v1.0", "capabilities", true, "capabilities"){

            @Override
            public URL getDocumentUrl(TapService tapService) {
                return tapService.getCapabilitiesEndpoint();
            }
        };
        this.tcapStage_ = new CapabilityStage(this.capabilitiesReader_);
        this.availXsdStage_ = new XsdStage("http://www.ivoa.net/xml/VOSIAvailability/v1.0", "availability", false, "availability"){

            @Override
            public URL getDocumentUrl(TapService tapService) {
                return tapService.getAvailabilityEndpoint();
            }
        };
        this.getQueryStage_ = new QueryStage(VotLintTapRunner.createGetSyncRunner(true), metaHolder, this.capabilitiesReader_);
        this.postQueryStage_ = new QueryStage(VotLintTapRunner.createPostSyncRunner(true), metaHolder, null);
        this.asyncQueryStage_ = new QueryStage(VotLintTapRunner.createAsyncRunner(500L, true), metaHolder, null);
        this.jobStage_ = new JobStage(metaHolder, 500L);
        this.colMetaStage_ = new ColumnMetadataStage(VotLintTapRunner.createGetSyncRunner(false), declaredMetaHolder, -1);
        this.uploadStage_ = new UploadStage(VotLintTapRunner.createAsyncRunner(500L, true), this.capabilitiesReader_);
        this.obstapStage_ = new ObsTapStage(VotLintTapRunner.createGetSyncRunner(true), this.capabilitiesReader_, new AnyMetadataHolder(new MetadataHolder[]{this.tapSchemaStage_, this.tmetaStage_}));
        this.obslocStage_ = new ObsLocStage(VotLintTapRunner.createGetSyncRunner(true), this.capabilitiesReader_, metaHolder);
        this.epntapStage_ = new EpnTapStage(VotLintTapRunner.createGetSyncRunner(true), metaHolder);
        this.exampleStage_ = new ExampleStage(VotLintTapRunner.createGetSyncRunner(true), this.capabilitiesReader_, new AnyMetadataHolder(new MetadataHolder[]{this.tapSchemaStage_, this.tmetaStage_}));
        this.stageSet_ = new StageSet();
        this.stageSet_.add("TMV", this.tmetaXsdStage_, true);
        this.stageSet_.add("TME", this.tmetaStage_, true);
        this.stageSet_.add("TMS", this.tapSchemaStage_, true);
        this.stageSet_.add("TMC", this.cfTmetaStage_, true);
        this.stageSet_.add("UUC", this.unitUcdStage_, true);
        this.stageSet_.add("CPV", this.tcapXsdStage_, true);
        this.stageSet_.add("CAP", this.tcapStage_, true);
        this.stageSet_.add("AVV", this.availXsdStage_, true);
        this.stageSet_.add("QGE", this.getQueryStage_, true);
        this.stageSet_.add("QPO", this.postQueryStage_, true);
        this.stageSet_.add("QAS", this.asyncQueryStage_, true);
        this.stageSet_.add("UWS", this.jobStage_, true);
        this.stageSet_.add(MDQ_NAME, this.colMetaStage_, true);
        this.stageSet_.add("OBS", this.obstapStage_, true);
        this.stageSet_.add("LOC", this.obslocStage_, true);
        this.stageSet_.add("EPN", this.epntapStage_, false);
        this.stageSet_.add("UPL", this.uploadStage_, true);
        this.stageSet_.add("EXA", this.exampleStage_, true);
    }

    public Map<String, Stage> getKnownStages() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, Stage>(this.stageSet_.stageMap_));
    }

    public boolean isDefault(String code) {
        return this.stageSet_.dflts_.contains(code);
    }

    public Executable createExecutable(final OutputReporter reporter, final IOSupplier<TapService> tapServiceSupplier, Set<String> stageCodeSet, int maxTestTables, final Predicate<TableMeta> tableFilter) throws TaskException {
        ArrayList<String> selectedCodeList = new ArrayList<String>();
        for (String knownCode : this.stageSet_.stageMap_.keySet()) {
            boolean selected = false;
            Iterator<String> sit = stageCodeSet.iterator();
            while (!selected && sit.hasNext()) {
                if (!knownCode.equalsIgnoreCase(sit.next())) continue;
                sit.remove();
                selected = true;
            }
            if (!selected) continue;
            selectedCodeList.add(knownCode);
        }
        if (!stageCodeSet.isEmpty()) {
            throw new TaskException("Unknown stage codes " + stageCodeSet);
        }
        final String[] codes = selectedCodeList.toArray(new String[0]);
        this.tapSchemaMetadata_.setReporter(reporter);
        this.colMetaStage_.setMaxTestTables(maxTestTables);
        final String[] announcements = TapLinter.getAnnouncements(true);
        return new Executable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() {
                TapService tapService;
                String uaToken = UserAgentUtil.COMMENT_TEST;
                try {
                    tapService = (TapService)tapServiceSupplier.get();
                }
                catch (IOException e) {
                    reporter.start(TapLinter.getAnnouncements(false));
                    reporter.startSection("PRE", "Preparation");
                    reporter.report(FixedCode.E_TAP0, "TAP service not present", e);
                    reporter.endSection();
                    reporter.end();
                    return;
                }
                TapLinter.this.capabilitiesReader_.init(reporter, tapService);
                UserAgentUtil.pushUserAgentToken((String)uaToken);
                try {
                    reporter.start(announcements);
                    for (int ic = 0; ic < codes.length; ++ic) {
                        String code = codes[ic];
                        Stage stage = TapLinter.this.stageSet_.getStage(code);
                        assert (stage != null);
                        if (stage instanceof TableMetadataStage && tableFilter != null) {
                            ((TableMetadataStage)stage).setTableFilter(tableFilter);
                        }
                        reporter.startSection(code, stage.getDescription());
                        stage.run(reporter, tapService);
                        reporter.summariseUnreportedMessages(code);
                        reporter.endSection();
                    }
                    reporter.end();
                }
                finally {
                    UserAgentUtil.popUserAgentToken((String)uaToken);
                }
            }
        };
    }

    public static String[] getAnnouncements(boolean includeCodes) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(new StringBuffer().append("This is STILTS taplint, ").append(Stilts.getVersion()).append("/").append(Stilts.getStarjavaRevision()).toString());
        lines.add("Timestamp: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date()));
        if (includeCodes) {
            LinkedHashMap<ReportType, int[]> codeMap = new LinkedHashMap<ReportType, int[]>();
            for (ReportType reportType : ReportType.values()) {
                codeMap.put(reportType, new int[1]);
            }
            for (Enum enum_ : FixedCode.values()) {
                int[] nArray = (int[])codeMap.get((Object)((FixedCode)enum_).getType());
                nArray[0] = nArray[0] + 1;
            }
            StringBuffer cbuf = new StringBuffer().append("Static report types: ");
            for (Map.Entry entry : codeMap.entrySet()) {
                cbuf.append(entry.getKey()).append("(").append(((int[])entry.getValue())[0]).append(")").append(", ");
            }
            cbuf.setLength(cbuf.length() - 2);
            lines.add(cbuf.toString());
        }
        return lines.toArray(new String[0]);
    }

    private static class CapabilitiesReader
    implements CapabilityHolder {
        private Reporter reporter_;
        private TapService tapService_;
        private CapabilityHolder holder_;

        private CapabilitiesReader() {
        }

        public void init(Reporter reporter, TapService tapService) {
            this.reporter_ = reporter;
            this.tapService_ = tapService;
        }

        @Override
        public Element getElement() {
            return this.getCapabilityHolder().getElement();
        }

        @Override
        public TapCapability getCapability() {
            return this.getCapabilityHolder().getCapability();
        }

        @Override
        public StdCapabilityInterface[] getInterfaces() {
            return this.getCapabilityHolder().getInterfaces();
        }

        @Override
        public String getServerHeader() {
            return this.getCapabilityHolder().getServerHeader();
        }

        private CapabilityHolder getCapabilityHolder() {
            if (this.holder_ == null) {
                this.holder_ = this.readCapabilityHolder();
            }
            return this.holder_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CapabilityHolder readCapabilityHolder() {
            TapCapability tapcap;
            StdCapabilityInterface[] intfs;
            Element el;
            String serverHdr;
            URL capUrl = this.tapService_.getCapabilitiesEndpoint();
            this.reporter_.report(FixedCode.I_CURL, "Reading capability metadata from " + capUrl);
            InputStream in = null;
            try {
                URLConnection conn = AuthManager.getInstance().connect(capUrl);
                serverHdr = conn.getHeaderField("server");
                in = new BufferedInputStream(conn.getInputStream());
                el = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in).getDocumentElement();
            }
            catch (SAXException e) {
                el = null;
                serverHdr = null;
                this.reporter_.report(FixedCode.E_CPSX, "Error parsing capabilities metadata", e);
            }
            catch (ParserConfigurationException e) {
                el = null;
                serverHdr = null;
                this.reporter_.report(FixedCode.F_CAPC, "Trouble setting up XML parse", e);
            }
            catch (IOException e) {
                el = null;
                serverHdr = null;
                this.reporter_.report(FixedCode.E_CPIO, "Error reading capabilities metadata", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            StdCapabilityInterface[] stdCapabilityInterfaceArray = intfs = el == null ? null : TapCapabilitiesDoc.getInterfaces(el);
            if (el != null) {
                try {
                    tapcap = TapCapabilitiesDoc.getTapCapability((Element)el);
                }
                catch (XPathExpressionException e) {
                    tapcap = null;
                    this.reporter_.report(FixedCode.E_CPSX, "Error parsing capabilities metadata", e);
                }
            } else {
                tapcap = null;
            }
            final Element el0 = el;
            final TapCapability tapcap0 = tapcap;
            final String serverHdr0 = serverHdr;
            return new CapabilityHolder(){

                @Override
                public Element getElement() {
                    return el0;
                }

                @Override
                public TapCapability getCapability() {
                    return tapcap0;
                }

                @Override
                public StdCapabilityInterface[] getInterfaces() {
                    return intfs;
                }

                @Override
                public String getServerHeader() {
                    return serverHdr0;
                }
            };
        }
    }

    private static class StageSet {
        Map<String, Stage> stageMap_ = new LinkedHashMap<String, Stage>();
        Set<String> dflts_ = new HashSet<String>();

        StageSet() {
        }

        void add(String code, Stage stage, boolean dflt) {
            this.stageMap_.put(code, stage);
            if (dflt) {
                this.dflts_.add(code);
            }
        }

        Stage getStage(String code) {
            return this.stageMap_.get(code);
        }
    }

    private static class AnyMetadataHolder
    implements MetadataHolder {
        private final MetadataHolder[] holders_;

        AnyMetadataHolder(MetadataHolder[] holders) {
            this.holders_ = holders;
        }

        @Override
        public SchemaMeta[] getTableMetadata() {
            MetadataHolder h = this.getBestHolder();
            return h == null ? null : h.getTableMetadata();
        }

        @Override
        public boolean hasDetail() {
            MetadataHolder h = this.getBestHolder();
            return h == null ? false : h.hasDetail();
        }

        private MetadataHolder getBestHolder() {
            ArrayList<MetadataHolder> popHolders = new ArrayList<MetadataHolder>();
            for (MetadataHolder h : this.holders_) {
                SchemaMeta[] smetas = h.getTableMetadata();
                if (smetas == null || smetas.length <= 0) continue;
                popHolders.add(h);
            }
            for (MetadataHolder h : popHolders) {
                if (!h.hasDetail()) continue;
                return h;
            }
            return popHolders.size() > 0 ? (MetadataHolder)popHolders.get(0) : null;
        }
    }
}

