/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.util.CountMap;

public class TextOutputReporter
implements OutputReporter {
    private final PrintStream out_;
    private final Collection<ReportType> typeList_;
    private final int maxRepeat_;
    private final boolean debug_;
    private final int maxChar_;
    private final CountMap<String> codeMap_;
    private final CountMap<ReportType> typeMap_;
    private final NumberFormat countFormat_;
    private final String countXx_;
    private String scode_;

    public TextOutputReporter(PrintStream out, ReportType[] types, int maxRepeat, boolean debug, int maxChar) {
        this.out_ = out;
        this.typeList_ = new HashSet<ReportType>(Arrays.asList(types));
        this.maxRepeat_ = maxRepeat;
        this.debug_ = debug;
        this.maxChar_ = maxChar;
        int maxDigit = (int)Math.ceil(Math.log10(this.maxRepeat_ + 1));
        this.countFormat_ = new DecimalFormat(TextOutputReporter.repeatChar('0', maxDigit));
        this.countXx_ = TextOutputReporter.repeatChar('x', maxDigit);
        this.codeMap_ = new CountMap();
        this.typeMap_ = new CountMap();
    }

    @Override
    public void start(String[] announcements) {
        for (String line : announcements) {
            this.println(line);
        }
    }

    @Override
    public void end() {
        this.println();
        this.reportTotals();
        this.println();
    }

    @Override
    public void startSection(String scode, String message) {
        this.println();
        this.println("Section " + scode + ": " + message);
        this.scode_ = scode;
    }

    @Override
    public String getSectionCode() {
        return this.scode_;
    }

    @Override
    public void summariseUnreportedMessages(String scode) {
        String dscode = scode == null ? "" : "-" + scode + "-";
        int lds = dscode.length();
        Iterator it = this.codeMap_.keySet().iterator();
        while (it.hasNext()) {
            String ecode = (String)it.next();
            if (!dscode.equals(ecode.substring(1, 1 + lds))) continue;
            int count = this.codeMap_.getCount((Object)ecode);
            if (count > this.maxRepeat_) {
                this.println(ecode + "-" + this.countXx_ + " (" + (count - this.maxRepeat_) + " more)");
            }
            it.remove();
        }
    }

    @Override
    public void endSection() {
        this.scode_ = null;
    }

    @Override
    public void report(ReportCode code, String message) {
        this.report(code, message, null);
    }

    @Override
    public void report(ReportCode code, String message, Throwable err) {
        ReportType type = code.getType();
        if (!this.typeList_.contains((Object)type)) {
            return;
        }
        if (message == null || message.trim().length() == 0) {
            message = "?";
        }
        StringBuffer codeBuf = new StringBuffer();
        codeBuf.append(type.getChar()).append('-');
        if (this.scode_ != null) {
            codeBuf.append(this.scode_).append('-');
        }
        codeBuf.append(code.getLabel());
        String ecode = codeBuf.toString();
        this.typeMap_.addItem((Object)type);
        int count = this.codeMap_.addItem((Object)ecode);
        if (count <= this.maxRepeat_) {
            String fcount = this.countFormat_.format(count);
            StringBuffer mbuf = new StringBuffer(message.trim());
            if (err != null) {
                mbuf.append(" [").append(this.stringifyError(err, false)).append("]");
            }
            String[] lines = mbuf.toString().split("[\\n\\r]+");
            for (int il = 0; il < lines.length; ++il) {
                String line = lines[il];
                if (line.trim().length() <= 0) continue;
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(ecode).append(il == 0 ? (char)'-' : '+').append(fcount).append(' ').append(lines[il]);
                this.println(sbuf.toString());
            }
        }
        if (this.debug_ && err != null) {
            err.printStackTrace(this.out_);
        }
    }

    private void reportTotals() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Totals: ");
        ReportType[] types = this.typeList_.toArray(new ReportType[0]);
        Arrays.sort((Object[])types);
        for (int i = 0; i < types.length; ++i) {
            ReportType type = types[i];
            if (i > 0) {
                sbuf.append("; ");
            }
            sbuf.append(type.getNames()).append(": ").append(this.typeMap_.getCount((Object)type));
        }
        this.println(sbuf.toString());
    }

    private String stringifyError(Throwable err, boolean showCauses) {
        String emsg2;
        Throwable err2;
        StringBuilder sbuf = new StringBuilder();
        String emsg = err.getMessage();
        if (emsg != null && emsg.trim().length() > 0) {
            sbuf.append(emsg);
        } else {
            sbuf.append(err.toString());
        }
        if (showCauses && (err2 = err.getCause()) != null && ((emsg2 = err2.getMessage()) == null || !emsg2.equals(emsg))) {
            sbuf.append("; ").append(this.stringifyError(err2, true));
        }
        return sbuf.toString();
    }

    private void println() {
        this.println("");
    }

    private void println(String line) {
        int leng = line.length();
        if (leng > this.maxChar_) {
            String ellipsis = "...";
            line = line.substring(0, this.maxChar_ - ellipsis.length()) + ellipsis;
        }
        this.out_.println(line);
    }

    private static String repeatChar(char chr, int count) {
        char[] chrs = new char[count];
        for (int i = 0; i < count; ++i) {
            chrs[i] = chr;
        }
        return new String(chrs);
    }
}

