/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.TableProducer;

public class SeqConcatStarTable
extends WrapperStarTable {
    private final ColumnInfo[] colInfos_;
    private final TableProducer[] tProds_;

    public SeqConcatStarTable(StarTable meta, TableProducer[] tProds) {
        super(meta);
        this.colInfos_ = Tables.getColumnInfos((StarTable)meta);
        this.tProds_ = tProds;
    }

    public boolean isRandom() {
        return false;
    }

    public Object getCell(long irow, int icol) {
        throw new UnsupportedOperationException();
    }

    public Object[] getRow(long irow) {
        throw new UnsupportedOperationException();
    }

    public long getRowCount() {
        return -1L;
    }

    public RowSequence getRowSequence() throws IOException {
        return new ConcatRowSequence();
    }

    public RowSplittable getRowSplittable() throws IOException {
        return new SeqConcatRowSplittable();
    }

    private void checkCompatible(StarTable table) throws IOException {
        if (table.getRowCount() == 0L) {
            return;
        }
        int ncol0 = this.colInfos_.length;
        int ncol1 = table.getColumnCount();
        if (ncol1 != ncol0) {
            throw new IOException("Column count mismatch (" + ncol1 + " != " + ncol0 + ")");
        }
        for (int icol = 0; icol < ncol0; ++icol) {
            ColumnInfo info0 = this.colInfos_[icol];
            ColumnInfo info1 = table.getColumnInfo(icol);
            if (info0.getContentClass().isAssignableFrom(info1.getContentClass()) && info0.isArray() == info1.isArray()) continue;
            throw new IOException("Column type mismatch (" + info1 + " not compatible with " + info0);
        }
    }

    private class SeqConcatRowSplittable
    implements RowSplittable {
        private int itab_;
        private int ntab_;
        private RowSequence rseq_;
        private StarTable table_;

        public SeqConcatRowSplittable() {
            this(-1, seqConcatStarTable.tProds_.length);
        }

        private SeqConcatRowSplittable(int itab, int ntab) {
            this.itab_ = itab;
            this.ntab_ = ntab;
        }

        public RowSplittable split() {
            if (this.rseq_ == null && this.ntab_ - this.itab_ > 2) {
                int mid = (1 + this.itab_ + this.ntab_) / 2;
                SeqConcatRowSplittable split = new SeqConcatRowSplittable(this.itab_, mid);
                this.itab_ = mid - 1;
                return split;
            }
            return null;
        }

        public long splittableSize() {
            return -1L;
        }

        public LongSupplier rowIndex() {
            return null;
        }

        public boolean next() throws IOException {
            while (true) {
                if (this.rseq_ == null) {
                    StarTable table;
                    if (this.itab_ + 1 == this.ntab_) {
                        return false;
                    }
                    ++this.itab_;
                    try {
                        table = SeqConcatStarTable.this.tProds_[this.itab_].getTable();
                    }
                    catch (TaskException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                    SeqConcatStarTable.this.checkCompatible(table);
                    this.rseq_ = table.getRowSequence();
                    this.table_ = table;
                    continue;
                }
                if (this.rseq_.next()) {
                    return true;
                }
                this.rseq_.close();
                this.rseq_ = null;
                if (this.table_ == null) continue;
                this.table_.close();
                this.table_ = null;
            }
        }

        public Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        public Object[] getRow() throws IOException {
            return this.rseq_.getRow();
        }

        public void close() throws IOException {
            if (this.rseq_ != null) {
                this.rseq_ = null;
                this.itab_ = this.ntab_;
            }
        }
    }

    private class ConcatRowSequence
    implements RowSequence {
        private final Iterator<TableProducer> prodIt;
        private RowSequence rseq_;
        private StarTable table_;

        private ConcatRowSequence() {
            this.prodIt = Arrays.asList(SeqConcatStarTable.this.tProds_).iterator();
            this.rseq_ = EmptyRowSequence.getInstance();
        }

        public boolean next() throws IOException {
            while (!this.rseq_.next()) {
                this.rseq_.close();
                if (this.table_ != null) {
                    this.table_.close();
                    this.table_ = null;
                }
                if (this.prodIt.hasNext()) {
                    StarTable table;
                    TableProducer tProd = this.prodIt.next();
                    try {
                        table = tProd.getTable();
                    }
                    catch (TaskException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                    SeqConcatStarTable.this.checkCompatible(table);
                    this.rseq_ = table.getRowSequence();
                    this.table_ = table;
                    continue;
                }
                return false;
            }
            return true;
        }

        public Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        public Object[] getRow() throws IOException {
            return this.rseq_.getRow();
        }

        public void close() throws IOException {
            this.rseq_.close();
        }
    }
}

