/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import org.xml.sax.Locator;
import uk.ac.starlink.ttools.votlint.ElementHandler;

public class ElementRef {
    private final String name_;
    private final int line_;
    private final int col_;
    private final ElementHandler handler_;
    private final String rep_;

    public ElementRef(ElementHandler handler, Locator locator) {
        this.handler_ = handler;
        this.name_ = handler.getName();
        this.line_ = locator == null ? -1 : locator.getLineNumber();
        this.col_ = locator == null ? -1 : locator.getColumnNumber();
        StringBuffer refbuf = new StringBuffer(handler.toString());
        if (this.line_ > 0) {
            refbuf.append(" (l.").append(this.line_);
            if (this.col_ > 0) {
                refbuf.append(", c.").append(this.col_);
            }
            refbuf.append(")");
        }
        this.rep_ = refbuf.toString();
    }

    public String getName() {
        return this.name_;
    }

    public ElementHandler getHandler() {
        return this.handler_;
    }

    public boolean equals(Object o) {
        if (o instanceof ElementRef) {
            ElementRef other = (ElementRef)o;
            return other.line_ == this.line_ && other.col_ == this.col_ && other.name_.equals(this.name_);
        }
        return false;
    }

    public int hashCode() {
        int code = 23;
        code = 97 * code + this.name_.hashCode();
        code = 97 * code + this.line_;
        code = 97 * code + this.col_;
        return code;
    }

    public String toString() {
        return this.rep_;
    }
}

