/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pds4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.pds4.DelimitedTable;
import uk.ac.starlink.pds4.Field;
import uk.ac.starlink.pds4.FieldReader;
import uk.ac.starlink.pds4.Group;
import uk.ac.starlink.pds4.Pds4StarTable;
import uk.ac.starlink.pds4.RecordItem;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.util.ByteList;

public class DelimitedPds4StarTable
extends Pds4StarTable {
    private final int delim_;
    private final int ncol_;
    private final int nfield_;
    private final ColumnReader[] colRdrs_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.pds4");

    public DelimitedPds4StarTable(DelimitedTable table, URI contextUri) throws IOException {
        super(table, contextUri);
        this.delim_ = table.getFieldDelimiter();
        this.colRdrs_ = DelimitedPds4StarTable.createColumnReaders(table.getContents());
        this.ncol_ = this.colRdrs_.length;
        this.nfield_ = DelimitedPds4StarTable.getFieldCount(table.getContents());
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colRdrs_[icol].getInfo();
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        final InputStream in = this.getDataStream();
        final ByteList buf = new ByteList(1024);
        final int[] iStarts = new int[this.nfield_];
        final int[] iEnds = new int[this.nfield_];
        final long nrow = this.getRowCount();
        return new RowSequence(){
            long irow_;
            byte[] bdata_;

            @Override
            public boolean next() throws IOException {
                if (this.irow_ < nrow && this.readLine()) {
                    ++this.irow_;
                    return true;
                }
                return false;
            }

            @Override
            public Object getCell(int icol) {
                this.checkRow();
                return this.doGetCell(icol);
            }

            @Override
            public Object[] getRow() {
                this.checkRow();
                Object[] row = new Object[DelimitedPds4StarTable.this.ncol_];
                for (int ic = 0; ic < DelimitedPds4StarTable.this.ncol_; ++ic) {
                    row[ic] = this.doGetCell(ic);
                }
                return row;
            }

            @Override
            public void close() throws IOException {
                in.close();
            }

            Object doGetCell(int icol) {
                return DelimitedPds4StarTable.this.colRdrs_[icol].readField(this.bdata_, iStarts, iEnds);
            }

            void checkRow() {
                if (this.irow_ == 0L) {
                    throw new IllegalStateException("No current row");
                }
            }

            boolean readLine() throws IOException {
                buf.clear();
                int iField = 0;
                iStarts[iField] = 0;
                boolean inQuote = false;
                int c;
                while ((c = in.read()) >= 0) {
                    if (c == 34 && buf.size() == iStarts[iField]) {
                        inQuote = true;
                        continue;
                    }
                    if (c == 34 && inQuote) {
                        inQuote = false;
                        continue;
                    }
                    if (!inQuote && c == DelimitedPds4StarTable.this.delim_) {
                        if (iField < DelimitedPds4StarTable.this.nfield_) {
                            iEnds[iField] = buf.size();
                        }
                        if (++iField >= DelimitedPds4StarTable.this.nfield_) continue;
                        iStarts[iField] = buf.size();
                        continue;
                    }
                    if (!inQuote && c == 10) {
                        if (iField < DelimitedPds4StarTable.this.nfield_) {
                            iEnds[iField] = buf.size();
                            if (buf.get(iEnds[iField] - 1) == 13) {
                                int n = iField;
                                iEnds[n] = iEnds[n] - 1;
                            }
                        }
                        this.bdata_ = buf.getByteBuffer();
                        return true;
                    }
                    buf.add((byte)c);
                }
                return false;
            }
        };
    }

    private static ColumnReader[] createColumnReaders(RecordItem[] items) {
        ArrayList<ColumnReader> list = new ArrayList<ColumnReader>();
        int ifield = 0;
        for (RecordItem item : items) {
            if (item instanceof Field) {
                list.add(new ScalarColumnReader((Field)item, ifield));
                ++ifield;
                continue;
            }
            if (!(item instanceof Group)) continue;
            Group group = (Group)item;
            if (group.getRepetitions() > 0) {
                int isub = 0;
                for (RecordItem subItem : group.getContents()) {
                    if (subItem instanceof Field) {
                        Field field = (Field)subItem;
                        FieldReader<?, ?> frdr = FieldReader.getInstance(field.getFieldType(), field.getBlankConstants());
                        VectorColumnReader<?, ?> crdr = DelimitedPds4StarTable.createVectorColumnReader(field, group, frdr, ifield + isub);
                        list.add(crdr);
                        ++isub;
                        continue;
                    }
                    if (!(subItem instanceof Group)) continue;
                    logger_.warning("Omit nested group");
                    Group subGroup = (Group)subItem;
                    isub += DelimitedPds4StarTable.getFieldCount(subGroup);
                }
            }
            ifield += DelimitedPds4StarTable.getFieldCount(group);
        }
        return list.toArray(new ColumnReader[0]);
    }

    private static int getFieldCount(Group group) {
        return DelimitedPds4StarTable.getFieldCount(group.getContents()) * group.getRepetitions();
    }

    private static int getFieldCount(RecordItem[] items) {
        int n = 0;
        for (RecordItem item : items) {
            if (item instanceof Field) {
                ++n;
                continue;
            }
            if (!(item instanceof Group)) continue;
            n += DelimitedPds4StarTable.getFieldCount((Group)item);
        }
        return n;
    }

    private static <S, A> VectorColumnReader<S, A> createVectorColumnReader(Field field, Group group, FieldReader<S, A> frdr, int iField0) {
        return new VectorColumnReader<S, A>(field, group, frdr, iField0);
    }

    private static class VectorColumnReader<S, A>
    implements ColumnReader {
        final FieldReader<S, A> fieldReader_;
        final ColumnInfo info_;
        final int iField0_;
        final int step_;
        final int nrep_;
        final int startBit_;
        final int endBit_;

        VectorColumnReader(Field field, Group group, FieldReader<S, A> fieldReader, int iField0) {
            this.fieldReader_ = fieldReader;
            this.iField0_ = iField0;
            this.nrep_ = group.getRepetitions();
            this.step_ = DelimitedPds4StarTable.getFieldCount(group) / this.nrep_;
            this.info_ = Pds4StarTable.createColumnInfo(field, this.fieldReader_.getArrayClass());
            this.info_.setShape(new int[]{this.nrep_});
            this.startBit_ = 0;
            this.endBit_ = 0;
        }

        @Override
        public ColumnInfo getInfo() {
            return this.info_;
        }

        public A readField(byte[] record, int[] iStarts, int[] iEnds) {
            A array = this.fieldReader_.createArray(this.nrep_);
            boolean hasData = false;
            for (int i = 0; i < this.nrep_; ++i) {
                int ifield = this.iField0_ + i * this.step_;
                int ioff = iStarts[ifield];
                int leng = iEnds[ifield] - ioff;
                if (leng <= 0) continue;
                this.fieldReader_.readElement(record, ioff, leng, this.startBit_, this.endBit_, array, i);
                hasData = true;
            }
            return (A)(hasData ? array : null);
        }
    }

    private static class ScalarColumnReader
    implements ColumnReader {
        final FieldReader<?, ?> fieldReader_;
        final int iField_;
        final ColumnInfo info_;
        final int startBit_;
        final int endBit_;

        ScalarColumnReader(Field field, int iField) {
            this.fieldReader_ = FieldReader.getInstance(field.getFieldType(), field.getBlankConstants());
            this.iField_ = iField;
            this.info_ = Pds4StarTable.createColumnInfo(field, this.fieldReader_.getScalarClass());
            this.startBit_ = 0;
            this.endBit_ = 0;
        }

        @Override
        public ColumnInfo getInfo() {
            return this.info_;
        }

        @Override
        public Object readField(byte[] record, int[] iStarts, int[] iEnds) {
            int ioff = iStarts[this.iField_];
            int leng = iEnds[this.iField_] - ioff;
            return leng > 0 ? this.fieldReader_.readScalar(record, ioff, leng, this.startBit_, this.endBit_) : null;
        }
    }

    private static interface ColumnReader {
        public ColumnInfo getInfo();

        public Object readField(byte[] var1, int[] var2, int[] var3);
    }
}

