/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pds4;

import gov.nasa.pds.label.object.FieldType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.pds4.BaseTable;
import uk.ac.starlink.pds4.DelimitedTable;
import uk.ac.starlink.pds4.Field;
import uk.ac.starlink.pds4.Group;
import uk.ac.starlink.pds4.Label;
import uk.ac.starlink.pds4.RecordItem;
import uk.ac.starlink.pds4.Table;
import uk.ac.starlink.pds4.TableType;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.util.DOMUtils;

public class LabelParser {
    private final boolean observationalOnly_;
    private final Collection<String> blankSpecials_;
    static final String[] DEFAULT_BLANK_SPECIALS = new String[]{"saturated_constant", "missing_constant", "error_constant", "invalid_constant", "unknown_constant", "not_applicable_constant", "high_instrument_saturation", "high_representation_saturation", "low_instrument_saturation", "low_representation_saturation"};

    public LabelParser() {
        this(false, DEFAULT_BLANK_SPECIALS);
    }

    public LabelParser(boolean observationalOnly, String[] blankSpecials) {
        this.observationalOnly_ = observationalOnly;
        this.blankSpecials_ = new HashSet<String>(Arrays.asList(blankSpecials));
    }

    public Label parseLabel(URL url) throws IOException {
        URI parent;
        try {
            URI labelUri = url.toURI();
            parent = labelUri.getPath().endsWith("/") ? labelUri.resolve("..") : labelUri.resolve(".");
        }
        catch (URISyntaxException e) {
            throw new TableFormatException("Badly-formed URL", e);
        }
        return this.parseLabel(url.openStream(), parent);
    }

    public Label parseLabel(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        File parentFile = file.getAbsoluteFile().getParentFile();
        return this.parseLabel(in, parentFile.toURI());
    }

    public Label parseLabel(InputStream in, URI contextUri) throws IOException {
        try {
            return this.attemptParseLabel(in, contextUri);
        }
        catch (SAXException e) {
            throw new TableFormatException("Label file not XML", e);
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw new TableFormatException("Library error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Label attemptParseLabel(InputStream in, final URI contextUri) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        finally {
            in.close();
        }
        XPath xpath = LabelParser.getXPath();
        NodeList tableNodes = (NodeList)xpath.evaluate(this.createTablesXpath(), doc, XPathConstants.NODESET);
        int nt = tableNodes.getLength();
        final ArrayList<Table> tableList = new ArrayList<Table>(nt);
        for (int it = 0; it < nt; ++it) {
            Table table = this.createTable((Element)tableNodes.item(it));
            if (table == null) continue;
            tableList.add(table);
        }
        return new Label(){

            @Override
            public URI getContextUri() {
                return contextUri;
            }

            @Override
            public Table[] getTables() {
                return tableList.toArray(new Table[0]);
            }
        };
    }

    private Table createTable(Element tEl) throws XPathExpressionException, TableFormatException {
        XPath xpath = LabelParser.getXPath();
        final TableType ttype = Arrays.stream(TableType.values()).filter(t -> t.getTableTag().equals(tEl.getTagName())).findFirst().get();
        assert (ttype != null);
        final String fileName = (String)xpath.evaluate("../" + LabelParser.xpathEl("File") + "/" + LabelParser.xpathEl("file_name"), tEl, XPathConstants.STRING);
        final long offset = Long.parseLong(LabelParser.getChildContent(tEl, "offset"));
        final long nrec = Long.parseLong(LabelParser.getChildContent(tEl, "records"));
        final String name = LabelParser.getChildContent(tEl, "name");
        final String localIdentifier = LabelParser.getChildContent(tEl, "local_identifier");
        final String description = LabelParser.getChildContent(tEl, "description");
        ArrayList fieldList = new ArrayList();
        Element recordEl = DOMUtils.getChildElementByName(tEl, ttype.getRecordTag());
        final RecordItem[] contents = this.getRecordItems(recordEl, ttype);
        switch (ttype) {
            case BINARY: 
            case CHARACTER: {
                String recordLengthTxt = (String)xpath.evaluate(".//" + LabelParser.xpathEl("record_length"), tEl, XPathConstants.STRING);
                final int recordLength = Integer.parseInt(recordLengthTxt);
                return new BaseTable(){

                    @Override
                    public int getRecordLength() {
                        return recordLength;
                    }

                    @Override
                    public String getFileName() {
                        return fileName;
                    }

                    @Override
                    public TableType getTableType() {
                        return ttype;
                    }

                    @Override
                    public long getOffset() {
                        return offset;
                    }

                    @Override
                    public long getRecordCount() {
                        return nrec;
                    }

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public String getLocalIdentifier() {
                        return localIdentifier;
                    }

                    @Override
                    public String getDescription() {
                        return description;
                    }

                    @Override
                    public RecordItem[] getContents() {
                        return contents;
                    }
                };
            }
            case DELIMITED: {
                String fieldDelimTxt = LabelParser.getChildContent(tEl, "field_delimiter");
                final char fieldDelim = LabelParser.getFieldDelimiterChar(fieldDelimTxt);
                return new DelimitedTable(){

                    @Override
                    public char getFieldDelimiter() {
                        return fieldDelim;
                    }

                    @Override
                    public String getFileName() {
                        return fileName;
                    }

                    @Override
                    public TableType getTableType() {
                        return ttype;
                    }

                    @Override
                    public long getOffset() {
                        return offset;
                    }

                    @Override
                    public long getRecordCount() {
                        return nrec;
                    }

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public String getLocalIdentifier() {
                        return localIdentifier;
                    }

                    @Override
                    public String getDescription() {
                        return description;
                    }

                    @Override
                    public RecordItem[] getContents() {
                        return contents;
                    }
                };
            }
        }
        assert (false);
        return null;
    }

    private Field createField(Element fEl) {
        final String name = LabelParser.getChildContent(fEl, "name");
        final String unit = LabelParser.getChildContent(fEl, "unit");
        final String description = LabelParser.getChildContent(fEl, "description");
        String dataType = LabelParser.getChildContent(fEl, "data_type");
        final FieldType ftype = FieldType.getFieldType(dataType);
        String locationTxt = LabelParser.getChildContent(fEl, "field_location");
        final int location = locationTxt == null || locationTxt.trim().length() == 0 ? -1 : Integer.parseInt(locationTxt);
        String lengTxt = LabelParser.getChildContent(fEl, "field_length");
        final int length = lengTxt == null || lengTxt.trim().length() == 0 ? -1 : Integer.parseInt(lengTxt);
        Element specialEl = DOMUtils.getChildElementByName(fEl, "Special_Constants");
        final String[] blankConstants = this.getBlankConstants(specialEl);
        return new Field(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public FieldType getFieldType() {
                return ftype;
            }

            @Override
            public int getFieldLocation() {
                return location;
            }

            @Override
            public int getFieldLength() {
                return length;
            }

            @Override
            public String getUnit() {
                return unit;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public String[] getBlankConstants() {
                return blankConstants;
            }
        };
    }

    private Group createGroup(Element gEl, TableType ttype) {
        assert (gEl.getTagName().equals(ttype.getGroupTag()));
        final String name = LabelParser.getChildContent(gEl, "name");
        final String description = LabelParser.getChildContent(gEl, "description");
        String repetitionsTxt = LabelParser.getChildContent(gEl, "repetitions");
        final int repetitions = Integer.parseInt(repetitionsTxt);
        String locationTxt = LabelParser.getChildContent(gEl, "group_location");
        final int location = locationTxt == null || locationTxt.trim().length() == 0 ? -1 : Integer.parseInt(locationTxt);
        String lengTxt = LabelParser.getChildContent(gEl, "group_length");
        final int length = lengTxt == null || lengTxt.trim().length() == 0 ? -1 : Integer.parseInt(lengTxt);
        final RecordItem[] contents = this.getRecordItems(gEl, ttype);
        return new Group(){

            @Override
            public int getRepetitions() {
                return repetitions;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public int getGroupLocation() {
                return location;
            }

            @Override
            public int getGroupLength() {
                return length;
            }

            @Override
            public RecordItem[] getContents() {
                return contents;
            }
        };
    }

    private RecordItem[] getRecordItems(Element containerEl, TableType ttype) {
        ArrayList<RecordItem> items = new ArrayList<RecordItem>();
        for (Node child = containerEl.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element el = (Element)child;
            String tagName = el.getTagName();
            if (ttype.getFieldTag().equals(tagName)) {
                items.add(this.createField(el));
                continue;
            }
            if (!ttype.getGroupTag().equals(tagName)) continue;
            items.add(this.createGroup(el, ttype));
        }
        return items.toArray(new RecordItem[0]);
    }

    private String createTablesXpath() {
        StringBuffer sbuf = new StringBuffer();
        for (TableType ttype : TableType.values()) {
            String elName = ttype.getTableTag();
            if (sbuf.length() > 0) {
                sbuf.append(" | ");
            }
            sbuf.append("//");
            if (this.observationalOnly_) {
                sbuf.append(LabelParser.xpathEl("File_Area_Observational")).append("/");
            }
            sbuf.append(LabelParser.xpathEl(elName));
        }
        return sbuf.toString();
    }

    private String[] getBlankConstants(Element specialEl) {
        if (specialEl == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Node child = specialEl.getFirstChild(); child != null; child = child.getNextSibling()) {
            String txt;
            Element el;
            if (!(child instanceof Element) || !this.blankSpecials_.contains((el = (Element)child).getTagName()) || (txt = DOMUtils.getTextContent(el)) == null || txt.trim().length() <= 0) continue;
            list.add(txt.trim());
        }
        return list.toArray(new String[0]);
    }

    private static XPath getXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    private static String getChildContent(Element el, String childName) {
        Element child = DOMUtils.getChildElementByName(el, childName);
        return child == null ? null : DOMUtils.getTextContent(child);
    }

    private static String xpathEl(String elName) {
        return "*[local-name()='" + elName + "']";
    }

    private static char getFieldDelimiterChar(String delimTxt) throws TableFormatException {
        if ("comma".equalsIgnoreCase(delimTxt)) {
            return ',';
        }
        if ("horizontal tab".equalsIgnoreCase(delimTxt)) {
            return '\t';
        }
        if ("semicolon".equalsIgnoreCase(delimTxt)) {
            return ';';
        }
        if ("vertical bar".equalsIgnoreCase(delimTxt)) {
            return '|';
        }
        throw new TableFormatException("Unknown record delimiter \"" + delimTxt + "\"");
    }
}

