/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.fits.ParsedCard;

public class CardType<T> {
    private final String name_;
    private final Class<T> clazz_;
    private final Pattern kvcPattern_;
    private final Function<String, T> decodeValue_;
    private static final String U_KEY8 = "[ A-Z0-9_-]{8}";
    private static final String B_KEYEQ = "([ A-Z0-9_-]{8})= ";
    private static final String B_HIEREQ = "(HIERARCH [-_A-Z0-9]+(?: [-_A-Z0-9]+)*) += ";
    private static final String B_OPTCOMMENT = " *(?:/ *(.*))?";
    private static final String B_QUOTED = " *'((?:[^']|'')*)'";
    private static final String B_LOGICAL = " *([TF])";
    private static final String B_INT = " *([-+]?[0-9]+)";
    private static final String U_FLOAT = "(?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?";
    private static final String B_FLOAT = " *((?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?)";
    private static final String B_COMPLEX = " *\\( *((?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)? *, *(?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?) *\\)";
    public static final CardType<Void> HISTORY = CardType.createType("HISTORY", Void.class, "(HISTORY) ()(.*)", t -> null);
    public static final CardType<Void> COMMENT = CardType.createType("COMMENT", Void.class, "(COMMENT) ()(.*)", t -> null);
    public static final CardType<Void> COMMENT_BLANK = CardType.createType("COMMENT_BLANK", Void.class, "()        ()(.*)", t -> null);
    public static final CardType<String> CONTINUE = CardType.createType("CONTINUE", String.class, "(CONTINUE)  *'((?:[^']|'')*)' *(?:/ *(.*))?", t -> CardType.parseQuoted(t));
    public static final CardType<Void> END = CardType.createType("END", Void.class, "(END)()() +", t -> null);
    public static final CardType<String> STRING = CardType.createType("STRING", String.class, "([ A-Z0-9_-]{8})=  *'((?:[^']|'')*)' *(?:/ *(.*))?", t -> CardType.parseQuoted(t));
    public static final CardType<String> STRING_HIER = CardType.createType("STRING_HIER", String.class, "(HIERARCH [-_A-Z0-9]+(?: [-_A-Z0-9]+)*) +=  *'((?:[^']|'')*)' *(?:/ *(.*))?", t -> CardType.parseQuoted(t));
    public static final CardType<Boolean> LOGICAL = CardType.createType("LOGICAL", Boolean.class, "([ A-Z0-9_-]{8})=  *([TF]) *(?:/ *(.*))?", t -> CardType.parseLogical(t));
    public static final CardType<Boolean> LOGICAL_HIER = CardType.createType("LOGICAL_HIER", Boolean.class, "(HIERARCH [-_A-Z0-9]+(?: [-_A-Z0-9]+)*) +=  *([TF]) *(?:/ *(.*))?", t -> CardType.parseLogical(t));
    public static final CardType<BigInteger> INTEGER = CardType.createType("INTEGER", BigInteger.class, "([ A-Z0-9_-]{8})=  *([-+]?[0-9]+) *(?:/ *(.*))?", BigInteger::new);
    public static final CardType<BigInteger> INTEGER_HIER = CardType.createType("INTEGER_HIER", BigInteger.class, "(HIERARCH [-_A-Z0-9]+(?: [-_A-Z0-9]+)*) +=  *([-+]?[0-9]+) *(?:/ *(.*))?", BigInteger::new);
    public static final CardType<Double> REAL = CardType.createType("REAL", Double.class, "([ A-Z0-9_-]{8})=  *((?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?) *(?:/ *(.*))?", t -> CardType.parseDouble(t));
    public static final CardType<Double> REAL_HIER = CardType.createType("REAL_HIER", Double.class, "(HIERARCH [-_A-Z0-9]+(?: [-_A-Z0-9]+)*) +=  *((?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?) *(?:/ *(.*))?", t -> CardType.parseDouble(t));
    public static final CardType<double[]> COMPLEX = CardType.createType("COMPLEX", double[].class, "([ A-Z0-9_-]{8})=  *\\( *((?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)? *, *(?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?) *\\) *(?:/ *(.*))?", t -> CardType.parseComplex(t));
    public static final CardType<double[]> COMPLEX_HIER = CardType.createType("COMPLEX_HIER", double[].class, "(HIERARCH [-_A-Z0-9]+(?: [-_A-Z0-9]+)*) +=  *\\( *((?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)? *, *(?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?) *\\) *(?:/ *(.*))?", t -> CardType.parseComplex(t));
    public static final CardType<Void> COMMENT_OTHER = CardType.createType("COMMENT_OTHER", Void.class, "()()([ A-Z0-9_-]{8}[^=].*)", t -> null);
    public static final CardType<Void> UNKNOWN = CardType.createType("UNKNOWN", Void.class, "()()().*", t -> null);
    public static final List<CardType<?>> CARD_TYPES = Collections.unmodifiableList(Arrays.asList(HISTORY, COMMENT, COMMENT_BLANK, CONTINUE, END, STRING, LOGICAL, INTEGER, REAL, COMPLEX, STRING_HIER, LOGICAL_HIER, INTEGER_HIER, REAL_HIER, COMPLEX_HIER, COMMENT_OTHER));
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    private CardType(String name, Class<T> clazz, String kvcRegex, Function<String, T> decodeValue) {
        this.name_ = name;
        this.clazz_ = clazz;
        this.kvcPattern_ = Pattern.compile(kvcRegex);
        this.decodeValue_ = decodeValue;
    }

    public String toString() {
        return this.name_;
    }

    public Class<T> getValueClass() {
        return this.clazz_;
    }

    public ParsedCard<T> toCard(final String txt80) {
        Matcher matcher = this.kvcPattern_.matcher(txt80);
        if (matcher.matches()) {
            T value;
            String key = matcher.group(1);
            String rawValue = matcher.group(2);
            String comment = matcher.group(3);
            try {
                value = this.decodeValue_.apply(rawValue);
            }
            catch (RuntimeException e) {
                logger_.warning("Bad " + this.name_ + " card value \"" + rawValue + "\": " + e);
                return null;
            }
            if (key != null) {
                key = key.trim();
            }
            if (comment != null) {
                comment = comment.trim();
            }
            return new ParsedCard<T>(key, this, value, comment){

                public String toString() {
                    return txt80;
                }
            };
        }
        return null;
    }

    private static <T> CardType<T> createType(String name, Class<T> clazz, String kvcRegex, Function<String, T> decode) {
        return new CardType<T>(name, clazz, kvcRegex, decode);
    }

    private static String parseQuoted(String txt) {
        if (txt.indexOf(39) >= 0) {
            txt = txt.replace("''", "'");
        }
        if (txt.endsWith(" ")) {
            txt = txt.replaceAll(" +$", "");
        }
        return txt;
    }

    private static Boolean parseLogical(String txt) {
        return "T".equals(txt);
    }

    private static double parseDouble(String txt) {
        return Double.valueOf(txt.replace('D', 'E'));
    }

    private static double[] parseComplex(String txt) {
        String[] pair = txt.split(",");
        return new double[]{CardType.parseDouble(pair[0]), CardType.parseDouble(pair[1])};
    }
}

