package fit.gui;

import fit.framework.MetadataTable;

/**
 * Utilities for use with the {@link ColumnsTableModel} class.
 *
 * @author   Mark Taylor
 * @since    7 Nov 2006
 */
class ColUtils {

    /**
     * Private sole constructor prevents instantiation.
     */
    private ColUtils() {
    }

    /**
     * Returns the content of a <code>MetadataTable</code> as an array
     * of <code>ColDef</code> objects.
     *
     * @param   metaTable  input metadata table
     * @return   array of ColDefs containing the data and metadata from
     *           <code>metaTable</code>
     */
    public static ColDef[] getColDefs( final MetadataTable metaTable ) {
        int ncol = metaTable.getColumnCount();
        ColDef[] colDefs = new ColDef[ ncol ];
        for ( int ic = 0; ic < ncol; ic++ ) {
            final int icol = ic;
            colDefs[ icol ] = new ColDef( metaTable.getColumnName( icol ),
                                          metaTable.getColumnClass( icol ) ) {
                public Object getValueAt( int irow ) {
                    return metaTable.getValueAt( irow, icol );
                }
            };
        }
        return colDefs;
    }

    /**
     * Returns a ColDef which just reports the (1-based) index of the row.
     *
     * @return  trivial coldef
     */
    public static ColDef getIndexColDef() {
        return new ColDef( "Index", Integer.class ) {
            public Object getValueAt( int irow ) {
                return new Integer( irow + 1 );
            }
        };
    }
}
