package fit.gui;

import java.text.DecimalFormat;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.StandardTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;

/**
 * Axis with characteristics suitable for use in the fitting package.
 * The basic <code>org.jfree.chart.axis.NumberAxis</code>
 * doesn't function well with large or small numeric ranges.
 * This one isn't brilliant, but it fails less often.
 *
 * @author    Mark Taylor
 * @since     23 Jan 2007
 */
public class NumericAxis extends NumberAxis {

    /**
     * Constructor.
     * A <code>sample</code> value should be supplied if possible, otherwise
     * is because the JFreeChart axis plotting can screw up if you are
     * many (tens of) orders of magnitude away from unity.
     * If there is no information, you can use NaN.
     *
     * @param  name  axis label
     * @param  includeZero   whether the axis should be forced to include zero
     *                       by default
     * @param  sample   ball-park estimate of the kinds of values that this
     *                  axis might hold, or NaN
     */
    NumericAxis( String name, boolean includeZero, double sample ) {
        super( name );
        setAutoRangeIncludesZero( includeZero );
        setAutoRangeMinimumSize( Double.MIN_VALUE );
        TickUnitSource tuSrc = new StandardTickUnitSource();
        setStandardTickUnits( tuSrc );
        if ( sample > 0.0 && sample < Double.MAX_VALUE ) {
            setTickUnit( (NumberTickUnit) tuSrc.getCeilingTickUnit( sample ) );
        }
        setAutoTickUnitSelection( true );
        // setNumberFormatOverride( new DecimalFormat( "##0.####E0" ) );
    }
}
