package fit.test;

import fit.framework.MetadataTable;
import fit.framework.ObservationSet;
import fit.framework.Theory;
import fit.framework.TheorySet;
import uk.ac.starlink.util.TestCase;

public class FitTestCase extends TestCase {

    public FitTestCase( String name ) {
        super( name );
    }

    public void assertTheorySetEquals( TheorySet t0, TheorySet t1 ) {
        assertEquals( t0.getMetadataX(), t1.getMetadataX() );
        assertEquals( t0.getMetadataY(), t1.getMetadataY() );
        assertEquals( t0.getTheoryCount(), t1.getTheoryCount() );
        for ( int ith = 0; ith < t0.getTheoryCount(); ith++ ) {
            assertTheoryEquals( t0.getTheory( ith ), t1.getTheory( ith ) );
        }
        assertMetadataTableEquals( t0.getMetadataTable(),
                                   t1.getMetadataTable() );
    }

    public void assertTheoryEquals( Theory t0, Theory t1 ) {
        assertEquals( t0.getCount(), t1.getCount() );
     // assertEquals( t0.getName(), t1.getName() );
        for ( int ip = 0; ip < t0.getCount(); ip++ ) {
            assertEquals( t0.getX( ip ), t1.getX( ip ) );
            assertEquals( t0.getY( ip ), t1.getY( ip ) );
        }
    }

    public void assertObservationSetEquals( ObservationSet o0,
                                            ObservationSet o1 ) {
        assertEquals( o0.getMetadataX(), o1.getMetadataX() );
        assertEquals( o0.getMetadataY(), o1.getMetadataY() );
        assertEquals( o0.getObsCount(), o1.getObsCount() );
        assertEquals( o0.getPointCount(), o1.getPointCount() );
        assertMetadataTableEquals( o0.getMetadataTable(),
                                   o1.getMetadataTable() );
        int npoint = o0.getPointCount();
        int nobs = o0.getObsCount();
        for ( int ip = 0; ip < npoint; ip++ ) {
            assertEquals( o0.getX( ip ), o1.getX( ip ) );
            assertEquals( o0.getXError( ip ), o1.getXError( ip ) );
            assertEquals( o0.getXFactor( ip ), o1.getXFactor( ip ) );
            for ( int iobs = 0; iobs < nobs; iobs++ ) {
                assertEquals( o0.getY( ip, iobs ), o1.getY( ip, iobs ) );
                assertEquals( o0.getYError( ip, iobs ),
                              o1.getYError( ip, iobs ) );
            }
        }
    }

    public void assertMetadataTableEquals( MetadataTable m0,
                                           MetadataTable m1 ) {
        assertEquals( m0.getColumnCount(), m1.getColumnCount() );
        assertEquals( m0.getRowCount(), m1.getRowCount() );
        for ( int icol = 0; icol < m0.getColumnCount(); icol++ ) {
            assertEquals( m0.getColumnName( icol ), m1.getColumnName( icol ) );
            assertEquals( m0.getColumnClass( icol ),
                          m1.getColumnClass( icol ) );
            for ( int irow = 0; irow < m0.getRowCount(); irow++ ) {
                assertEquals( m0.getValueAt( irow, icol ),
                              m1.getValueAt( irow, icol ) );
            }
        }
    }
}
