package fit.util;

import fit.framework.Theory;

/**
 * Theory implementation which multiplies the X values by a positive factor.
 *
 * @author   Mark Taylor
 * @since    16 Oct 2006
 */
public class XFactorTheory extends WrapperTheory {

    private final double xfactor_;

    /**
     * Constructor.
     *
     * @param   base  theory
     * @param   xfactor  value by which all X coordinates in the base theory
     *          are multiplied for this model
     */
    public XFactorTheory( Theory base, double xfactor ) {
        super( base );
        if ( ! ( xfactor > 0 ) ) {
            throw new IllegalArgumentException( "Non-positive factor: "
                                              + xfactor );
        }
        xfactor_ = xfactor;
    }

    public String getName() {
        return super.getName() + ",shift*" + Float.toString( (float) xfactor_ );
    }

    public double getX( int ip ) {
        return super.getX( ip ) * xfactor_;
    }

    public int getFloorIndex( double x ) {
        return super.getFloorIndex( x / xfactor_ );
    }
}
