package fit.test;

import fit.formats.SvoTarTheoryReader;
import fit.framework.MetadataTable;
import fit.framework.Theory;
import fit.framework.TheorySet;
import fit.util.FitUtils;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import uk.ac.starlink.util.DataSource;

public class SvoTarTest extends TestCase {

    public static final String TEST_RESOURCE = "svo.tar.gz";

    public SvoTarTest( String name ) {
        super( name );
    }

    public void testReject() throws IOException {
        URL url = getClass().getResource( "SvoTarTest.class" );
        try {
            new SvoTarTheoryReader()
               .readTheories( DataSource.makeDataSource( url ) );
            fail();
        }
        catch ( IOException e ) {
            assertEquals( "Not a tar file", e.getMessage() );
        }
    }

    public void testRead() throws IOException {
        URL url = getClass().getResource( TEST_RESOURCE );
        TheorySet tset = new SvoTarTheoryReader()
                        .readTheories( DataSource.makeDataSource( url ) );

        int nth = tset.getTheoryCount();
        assertEquals( 5, nth );
        for ( int ith = 0; ith < nth; ith++ ) {
            Theory th = tset.getTheory( ith );
            assertEquals( 1221, th.getCount() );
            assertEquals( -1, th.getFloorIndex( 90 ) );
            assertEquals( 0, th.getFloorIndex( 91 ) );
        }
        {
            double x = tset.getTheory( 1 ).getX( 682 );
            double y = tset.getTheory( 1 ).getY( 682 );
            assertEquals( 10025, x, 1e-6 );
            assertEquals( 1.0,
                          1.286e-13 / ( 3e-5 * y / ( x * x ) ),
                          1e-2 );
        }

        MetadataTable meta = tset.getMetadataTable();
        int teffIndex = FitUtils.getColumnIndex( meta, "teff" );
        int loggIndex = FitUtils.getColumnIndex( meta, "logg" );
        assertEquals( 6000,
                      FitUtils.getNumber( meta.getValueAt( 1, teffIndex ) ),
                      1e-10 );
        assertEquals( 0.5,
                      FitUtils.getNumber( meta.getValueAt( 1, loggIndex ) ),
                      1e-10 );
    }
}
