package fit.test;

import fit.task.Yafit;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class TaskTest extends TestCase {

    public TaskTest( String name ) {
        super( name );
    }

    public void testTaskFactory() throws LoadException {
        ObjectFactory fact = Yafit.getTaskFactory();
        for ( Iterator it = Arrays.asList( fact.getNickNames() ).iterator();
              it.hasNext(); ) {
             assertTrue( fact.createObject( (String) it.next() )
                         instanceof Task );
        }
    }

    public void testVersion() {
        String version = Yafit.getVersion();
        char vc = version.charAt( 0 );
        assertTrue( vc >= '0' && vc <= '9' );
    }
}
