package fit.util;

import fit.framework.Theory;

/**
 * Abstract Theory implementation which is based on an existing 
 * Theory but manipulates its Y values.  This is suitable for unit
 * changes etc.  Concrete subclasses must provide a suitable
 * implementation of {@link #transformY}.
 *
 * @author   Mark Taylor
 * @since    13 Oct 2006
 */
public abstract class TransformerTheory extends WrapperTheory {

    /** 
     * Constructor.
     *
     * @param   base   base theory
     */
    protected TransformerTheory( Theory base ) {
        super( base );
    }

    /**
     * Transforms the Y value from the base theory to the Y value for this
     * one.
     *
     * @param   y   base Y value
     * @return   transformed Y value
     */
    public abstract double transformY( double y );

    /**
     * Gives the name of this theory given the name of the base theory.
     *
     * @param   name  base name
     * @return   name of this theory
     */
    public abstract String transformName( String name );

    public double getY( int i ) {
        return transformY( super.getY( i ) );
    }

    public String getName() {
        return transformName( super.getName() );
    }
}
