package fit.util;

import fit.framework.MetadataItem;
import fit.framework.MetadataTable;
import fit.framework.Theory;
import fit.framework.TheorySet;

/**
 * TheorySet implementation which is based on an existing TheorySet.
 *
 * @author   Mark Taylor
 * @since    24 Jan 2007
 */
public class WrapperTheorySet implements TheorySet {

    private final TheorySet base_;

    /**
     * Constructor.
     *
     * @param   base  base theory set
     */
    public WrapperTheorySet( TheorySet base ) {
        base_ = base;
    }

    public int getTheoryCount() {
        return base_.getTheoryCount();
    }

    public Theory getTheory( int ith ) {
        return base_.getTheory( ith );
    }

    public int getIndex( Theory theory ) {
        return base_.getIndex( theory );
    }

    public MetadataItem getMetadataX() {
        return base_.getMetadataX();
    }

    public MetadataItem getMetadataY() {
        return base_.getMetadataY();
    }

    public MetadataTable getMetadataTable() {
        return base_.getMetadataTable();
    }
}
