package fit.formats;

import java.io.IOException;

/**
 * Exception thrown if an attempt is made to read a data file 
 * which does not conform to the intended format.
 *
 * @author   Mark Taylor
 * @since    19 Jan 2007
 */
public class FileFormatException extends IOException {

    public FileFormatException() {
        super();
    }

    public FileFormatException( String msg ) {
        super( msg );
    }

    public FileFormatException( Throwable e ) {
        super( "Data in incorrect format" );
        initCause( e );
    }

    public FileFormatException( String msg, Throwable e ) {
        super( msg );
        initCause( e );
    }
}
