package fit.framework;

/**
 * Determines the value of a notionally continuous function, as embodied
 * in a {@link Theory} object, at a given point.
 * The process by which the value is determined need not actually be
 * interpolation as such.
 *
 * @author   Mark Taylor
 * @since    13 Oct 2006
 */
public interface Interpolator {

    /**
     * Returns the value of the <code>theory</code> function at a given
     * <code>x</code> value.  If no value can be calculated, the result
     * may be NaN.  This will typically be the case if extrapolation is
     * required (the supplied abscissa is outside the range over which 
     * the function is defined).
     *
     * @param   theory  theory object describing function
     * @param   x   abscissa at which the function described by 
     *              <code>theory</code> is to be evaluated
     * @return  value of <code>theory</code>'s ordinate at <code>x</code>
     */
    public double getY( Theory theory, double x );
}
