package fit.framework;

/**
 * Table-like interface for storing items of metadata.
 * This interface is a subset of {@link javax.swing.table.TableModel},
 * and resembles a simplified version of 
 * <code>uk.ac.starlink.table.StarTable</code>.
 * It is provided here rather than co-opting either of those to reduce
 * dependencies on those packages in the fitting framework, mainly for
 * the sake of clarity.
 *
 * @author   Mark Taylor
 * @since    7 Nov 2006
 */
public interface MetadataTable {

    /**
     * Returns the number of columns (items of metadata for each row).
     *
     * @return  column count
     */
    int getColumnCount();

    /**
     * Returns the number of rows (items described by metadata).
     *
     * @return  row count
     */
    int getRowCount();

    /**
     * Returns the name of a given column (metadata item).
     *
     * @param   icol  column index
     * @return  column name
     */
    String getColumnName( int icol );

    /**
     * Returns the class of object contained in a given column (metadata item).
     *
     * @param  icol  column index
     * @return  column content class
     */
    Class getColumnClass( int icol );

    /**
     * Returns a metadata item.
     *
     * @param   irow   row index
     * @param   icol   column index
     * @return  metadata item
     */
    Object getValueAt( int irow, int icol );
}
