package fit.framework;

import java.io.IOException;

/**
 * Interface defining how to dispose of the results of comparing one or
 * more theories with an observation.
 *
 * @author   Mark Taylor
 * @since    27 Oct 2006
 */
public interface ResultSink {

    /**
     * Advises the sink of a newly generated set of comparisons.
     *
     * @param  obsSet  observation set
     * @param  iobs    index of the relevant observation in <code>obsSet</code>
     * @param  comparisons  array giving the details of the theory comparisons
     *         with the observation
     * @param  theorySet  set of theories referenced by <code>comparisons</code>
     *         (may be null)
     */
    void addResult( ObservationSet obsSet, int iobs, Comparison[] comparisons,
                    TheorySet theorySet )
            throws IOException;

    /**
     * May be invoked to indicate that no more results will be added.
     */
    void close() throws IOException;
}
