package fit.framework;

import java.io.IOException;
import uk.ac.starlink.util.DataSource;

/**
 * Interface for objects which can acquire Theory data from an input stream.
 *
 * @author   Mark Taylor
 * @since    26 Oct 2006
 */
public interface TheoryReader {

    /**
     * Reads an list of theories by deserialising a stream of bytes.
     *
     * @param   src  source of data
     * @return   array of theories that have been read
     */
    TheorySet readTheories( DataSource src ) throws IOException;
}
