package fit.framework;

/**
 * Contains a list of theories and optionally some associated metadata.
 *
 * @author   Mark Taylor
 * @since    8 Nov 2006
 */
public interface TheorySet {

    /**
     * Returns the number of theories in this set.
     *
     * @return  theory count
     */
    int getTheoryCount();

    /**
     * Returns the theory at a given index.
     *
     * @param  ith  theory index
     * @return   theory at index <code>ith</code>
     */
    Theory getTheory( int ith );

    /**
     * Returns the index associated with a given theory.
     *
     * <p><code>getIndex(getTheory(i))==i</code> should always be true.
     * However, the implementation may choose to return <code>i</code> 
     * for objects which are not equal to <code>getTheory(i)</code> as well,
     * for instance if they are theories based on <code>getTheory(i)</code>.
     * If no index is associated with <code>theory</code>, -1 is returned.
     *
     * @param  theory   theory
     * @return   index of <code>theory</code> in this set, or -1
     */
    int getIndex( Theory theory );

    /**
     * Returns information about the X values of the theories in this set.
     *
     * @return   X values metadata
     */
    MetadataItem getMetadataX();


    /**
     * Returns information about the Y values of the theories in this set.
     *
     * @return   Y values metadata
     */
    MetadataItem getMetadataY();

    /**
     * May return a table which contains additional metadata for the 
     * theories in this set.  If the result is non-null, then the N'th row
     * of the resulting table provides information about the N'th theory
     * in this set.
     *
     * @return  table giving per-observation metadata about this set, or null
     */
    MetadataTable getMetadataTable();
}
