package fit.gui;

/**
 * Defines the data and metadata of a column in a ColumnsTableModel.
 *
 * @author   Mark Taylor
 * @since    7 Nov 2006
 */
public abstract class ColDef {

    private final String name_;
    private final Class clazz_;

    /**
     * Constructor.
     *
     * @param   name   column name
     * @param   clazz  class of all objects in this column
     */
    public ColDef( String name, Class clazz ) {
        name_ = name;
        clazz_ = clazz;
    }

    /**
     * Returns the name of this column.
     *
     * @return  column name
     */
    public String getColumnName() {
        return name_;
    }

    /**
     * Returns the class of objects in this column.
     *
     * @return   column class
     */
    public Class getColumnClass() {
        return clazz_;
    }

    /**
     * Returns the value in this column for a given table row.
     *
     * @param  irow   row index
     * @return   column contents - should be assignable from
     *           {@link #getColumnClass}
     */
    public abstract Object getValueAt( int irow );
}
