package fit.run;

import fit.formats.GalaxevTheoryReader;
import fit.framework.Interpolator;
import fit.framework.MetadataItem;
import fit.framework.ObservationSet;
import fit.framework.Theory;
import fit.framework.TheoryReader;
import fit.framework.TheorySet;
import fit.util.FitUtils;
import fit.util.MagToFluxObservationSet;
import fit.util.SquareSmoother;
import fit.util.TableObservationSetFactory;
import fit.util.TheoryFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.DataSource;

/**
 * Example code to do fitting on Paresh Prema's data.
 *
 * @author   Mark Taylor
 * @since    13 Oct 2006
 */
public class Paresh extends Runner {

    public ObservationSet readObservations() throws IOException {
        File file = new File( DATA_DIR, "paresh-xmatch.vot" );
        StarTable table = tableFactory_.makeStarTable( file.toString(),
                                                       "votable" );
        TableObservationSetFactory obsFact =
            new TableObservationSetFactory( table,
                                            MetadataItem.WAVELENGTH_A,
                                            MetadataItem.MAGNITUDE );
        obsFact.setInterpolatorFactory( SquareSmoother.getFactory() );
        obsFact.definePoint( 3600, 400, "U", "U_ERR" );
        obsFact.definePoint( 4500, 700, "B", "B_ERR" );
        obsFact.definePoint( 5400, 600, "V", "V_ERR" );
        obsFact.definePoint( 6750, 1250, "R", "R_ERR" );
        obsFact.definePoint( 9150, 1850, "I", "I_ERR" );
        obsFact.definePoint( 12500, 2500, "MAG_ISAAC_J", "MAGERR_ISAAC_J" );
        obsFact.definePoint( 16500, 2000, "MAG_ISAAC_H", "MAGERR_ISAAC_H" );
        obsFact.definePoint( 22000, 3000, "MAG_ISAAC_Ks", "MAGERR_ISAAC_Ks" );
        obsFact.definePoint( 36000, 6000, "MAG_3_6", "MAGERR_3.6" );
        obsFact.definePoint( 45000, 6000, "MAG_4_5", "MAGERR_4_5" );
        obsFact.definePoint( 58000, 6000, "MAG_5_8", "MAGERR_5.8" );
        obsFact.defineRedshift( "PhotoZ" );
        return new MagToFluxObservationSet( obsFact.createObservationSet() );
    }

    public TheorySet readTheories() throws IOException {
        String[] gfiles = { "paresh-a1.galaxev", "paresh-a2.galaxev", };
        TheoryReader greader = new GalaxevTheoryReader();
        TheorySet[] tsets = new TheorySet[ gfiles.length ];
        for ( int i = 0; i < gfiles.length; i++ ) {
            tsets[ i ] = greader.readTheories( DataSource
                                              .makeDataSource( gfiles[ i ] ) );
        }
        return FitUtils.concatTheorySets( tsets );
    }
}
