package fit.run;

import fit.framework.Comparison;
import fit.framework.ObservationSet;
import fit.framework.ResultSink;
import fit.framework.TheorySet;
import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.util.Destination;
import uk.ac.starlink.util.IOUtils;

/**
 * ResultSink which just prints a one-line summary (the best match) from
 * each batch of comparisons.
 *
 * @author   Mark Taylor
 * @since    27 Oct 2006
 */
public class ResultSummary implements ResultSink {

    private final Destination dest_;
    private OutputStream out_;

    /**
     * Constructs a ResultSummary which writes to System.out.
     */
    public ResultSummary() {
        this( Destination.SYSTEM_OUT );
    }

    /**
     * Constructs a ResultSummary which writes to a given destination.
     *
     * @param   dest   destination stream
     */
    public ResultSummary( Destination dest ) {
        dest_ = dest;
    }

    public void addResult( ObservationSet obsSet, int iobs,
                           Comparison[] comparisons, TheorySet theorySet )
            throws IOException {
        Comparison best = comparisons[ 0 ];
        for ( int ic = 0; ic < comparisons.length; ic++ ) {
            Comparison comp = comparisons[ ic ];
            if ( comp.getScore() < best.getScore() ) {
                best = comp;
            }
        }
        if ( out_ == null ) {
            out_ = dest_.createStream();
        }
        IOUtils.println( out_, ( iobs + 1 ) + ":\t" + best );
    }

    public void close() {
    }
}
