package fit.run;

import fit.framework.ObservationSet;
import fit.framework.TheorySet;
import fit.test.TestData;
import java.util.Random;

/**
 * Runner implmentation which uses synthetic theory and observation data.
 *
 * @author   Mark Taylor
 * @since    16 Nov 2006
 */
public class TestRunner extends Runner {

    private final TestData data_;

    /**
     * Constructor.
     */
    TestRunner() {
        data_ = new TestData( new Random( -232323L ) );
    }

    public ObservationSet readObservations() {
        return data_.getObservationSet( 20, 11 );
    }

    public TheorySet readTheories() {
        return data_.getTheorySet( 25, 1600 );
    }
}
