package fit.task;

import fit.framework.TheoryReader;
import fit.formats.GalaxevTheoryReader;
import fit.formats.ModelTableTheoryReader;
import fit.formats.Starburst99TheoryReader;
import fit.formats.SvoTarTheoryReader;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.util.ObjectFactory;
import uk.ac.starlink.task.ObjectFactoryParameter;

/**
 * Parameter which specifies the data format of theory data files.
 *
 * @author   Mark Taylor
 * @since    22 Nov 2006
 */
public class TheoryReaderParameter extends ObjectFactoryParameter {

    private static final ObjectFactory READER_FACTORY = createReaderFactory();

    /**
     * Constructor.
     *
     * @param   name  parameter name
     */
    public TheoryReaderParameter( String name ) {
        super( name, READER_FACTORY );
        setUsage( "<model-format>" );
        setPrompt( "Format for model data" );
    }

    /**
     * Returns the value of this parameter as a TheoryReader object.
     *
     * @param  env  execution environment
     * @return   theory reader
     */
    public TheoryReader readerValue( Environment env ) throws TaskException {
        return (TheoryReader) super.objectValue( env );
    }

    /**
     * Returns a new ObjectFactory which generates TheoryReader objects.
     *
     * @return  theory reader factory
     */
    private static ObjectFactory createReaderFactory() {
        ObjectFactory fact = new ObjectFactory( TheoryReader.class );
        fact.register( "ymodel",
                       ModelTableTheoryReader.class.getName() );
        fact.register( "galaxev", GalaxevTheoryReader.class.getName() );
        fact.register( "starburst99", Starburst99TheoryReader.class.getName() );
        fact.register( "svotar", SvoTarTheoryReader.class.getName() );
        fact.register( "sideways-vot",
                       fit.formats.SidewaysTableTheoryReader.VOTable.class
                      .getName() );
        return fact;
    }
}
