package fit.test;

import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FitTests extends TestSuite {

    /**
     * Constructor.
     */
    public FitTests() {
        addTestSuite( ComparisonTest.class );
        addTestSuite( FitCalculatorTest.class );
        addTestSuite( FittingTest.class );
        addTestSuite( GalaxevTest.class );
        addTestSuite( InterpolatorTest.class );
        addTestSuite( MetadataTableTest.class );
        addTestSuite( ModelTableTest.class );
        addTestSuite( ObservationSetIOTest.class );
        addTestSuite( RunnerTest.class );
        addTestSuite( Starburst99Test.class );
        addTestSuite( SvoTarTest.class );
        addTestSuite( TaskTest.class );
        addTestSuite( TheoryTest.class );
        addTestSuite( TheorySetTest.class );
        addTestSuite( UtilsTest.class );
    }

    /**
     * Run JUnit tests for the fitting packages.
     *
     * @param  args  ignored
     */
    public static void main( String[] args ) {
        Logger.getLogger( "" ).setLevel( Level.WARNING );
        TestRunner.run( new FitTests() );
    }
}
