package fit.test;

import fit.formats.ObservationSetReader;
import fit.formats.ObservationSetWriter;
import fit.framework.Interpolator;
import fit.framework.ObservationSet;
import fit.util.InterpolatorFactory;
import fit.util.SquareSmoother;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import uk.ac.starlink.util.ByteArrayDataSource;

public class ObservationSetIOTest extends FitTestCase {

    public ObservationSetIOTest( String name ) {
        super( name );
    }

    public void testIO() throws IOException {
        ObservationSet obsSet0 =
            new TestData( -253L ).getObservationSet( 23, 6 );
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new ObservationSetWriter().write( obsSet0, out );
        out.close();
        InterpolatorFactory interpFact = new InterpolatorFactory() {
            public Interpolator getInterpolator( double x, double xerr ) {
                return new SquareSmoother( xerr * 2 );
            }
        };
        ObservationSet obsSet1 =
            new ObservationSetReader( interpFact )
           .readObservations( new ByteArrayDataSource( "data",
                                                       out.toByteArray() ) );
        assertObservationSetEquals( obsSet0, obsSet1 );
    }
}
