package fit.test;

import fit.framework.ResultSink;
import fit.run.Runner;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import junit.framework.TestCase;

public class RunnerTest extends TestCase {

    public RunnerTest( String name ) {
        super( name );
    }

    public void testSinks() throws Exception {
        for ( Iterator it = Runner.getSinkMap().values().iterator();
              it.hasNext(); ) {
            String classname = (String) it.next();
            Class clazz = Class.forName( classname );
            assertTrue( ResultSink.class.isAssignableFrom( clazz ) );
            int cflags = clazz.getConstructor( new Class[ 0 ] ).getModifiers();
            assertTrue( Modifier.isPublic( cflags ) );
            assertTrue( ! Modifier.isAbstract( cflags ) );
            assertTrue( ! Modifier.isInterface( cflags ) );
        }
    }
}
