package fit.test;

import fit.formats.Starburst99TheoryReader;
import fit.framework.MetadataTable;
import fit.framework.Theory;
import fit.framework.TheorySet;
import fit.util.FitUtils;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import uk.ac.starlink.util.DataSource;

public class Starburst99Test extends TestCase {

    public static final String TEST_RESOURCE = "starburst99.dat";

    public Starburst99Test( String name ) {
        super( name );
    }

    public void testRead() throws IOException {
        URL url = getClass().getResource( TEST_RESOURCE );
        TheorySet tset = new Starburst99TheoryReader()
                        .readTheories( DataSource.makeDataSource( url ) );

        int nth = tset.getTheoryCount();
        assertEquals( 8, nth );
        for ( int ith = 0; ith < nth; ith++ ) {
            Theory th = tset.getTheory( ith );
            assertEquals( 10, th.getCount() );
            assertEquals( -1, th.getFloorIndex( 90 ) );
            assertEquals( 0, th.getFloorIndex( 92 ) );
        }
        assertEquals( 110, tset.getTheory( 3 ).getX( 9 ), 1e-12 );
        assertEquals( 1.0, 
                      ( 1e10 * Math.pow(110e-10,2)/3e8 * Math.exp( 17.84334 ) )
                    / ( tset.getTheory( 3 ).getY( 9 ) ),
                      1e-3 );

        MetadataTable meta = tset.getMetadataTable();
        int ageIndex = FitUtils.getColumnIndex( meta, "TIME" );
        assertEquals( 0, ageIndex );
        assertEquals( 0.60265e7,
                      FitUtils.getNumber( meta.getValueAt( 3, ageIndex ) ),
                      1e-1 );
    }
}
