package fit.test;

import junit.framework.TestCase;
import fit.framework.Theory;
import fit.util.ArraysTheory;

public class TheoryTest extends TestCase {

    public TheoryTest( String name ) {
        super( name );
    }

    public void testArraysTheory() {
        Theory fib = TestUtils.getFibonacciTheory( 10 );
        assertTrue( fib instanceof ArraysTheory );
        assertEquals( 0., fib.getX( 0 ), 0. );
        assertEquals( 0., fib.getY( 0 ), 0. );
        assertEquals( 7., fib.getX( 7 ), 0. );
        assertEquals( 13., fib.getY( 7 ), 0. );
        assertEquals( 7, fib.getFloorIndex( 7.9 ) );
        assertEquals( 8, fib.getFloorIndex( 8.0 ) );
        assertEquals( 8, fib.getFloorIndex( 8.1 ) );
        assertEquals( -1, fib.getFloorIndex( -0.1 ) );
        assertEquals( 9, fib.getFloorIndex( 1e9 ) );
    }
}
