package fit.util;

import fit.framework.Theory;

/**
 * Transforms a Theory by converting Y values from AB magnitudes to
 * fluxes in Jansky.
 * The transformation formula is
 * <blockquote>
 *    <i>flux</i> = 10<sup>(23 - (<i>mag</i> + 48.6) / 2.5)
 * </blockquote>
 *
 * @author   Mark Taylor
 * @since    13 Oct 2006
 */
public class MagToFluxTheory extends TransformerTheory {

    private final double K = 1e23 * Math.pow( 10.0, -0.4 * 48.6 );

    /**
     * Constructor.
     *
     * @param   base  theory which provides its Y values in AB magnitudes
     */
    public MagToFluxTheory( Theory base ) {
        super( base );
    }

    public double transformY( double mag ) {
        double flux = K * Math.pow( 10.0, -0.4 * mag );
        return flux;
    }

    public String transformName( String name ) {
        return( "Flux(" + name + ")" );
    }
}
