package fit.util;

import fit.framework.MetadataTable;
import java.util.Map;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.MapGroup;

/**
 * MetadataTable implementation based on a MapGroup.
 * This is an adaptor.
 *
 * @author   Mark Taylor
 * @since    15 Jan 2007
 */
public class MapGroupMetadataTable implements MetadataTable {

    private final MapGroup mapGroup_;

    /**
     * Constructor.
     *
     * @param   mapGroup  map group supplying data
     */
    public MapGroupMetadataTable( MapGroup mapGroup ) {
        mapGroup_ = mapGroup;
    }

    private DescribedValue getDescribedValue( int irow, int icol ) {
        return (DescribedValue) ((Map) mapGroup_.getMaps().get( irow ))
                               .get( mapGroup_.getKnownKeys().get( icol ) );
    }

    private ValueInfo getInfo( int icol ) {
        return getDescribedValue( 0, icol ).getInfo();
    }

    public Class getColumnClass( int icol ) {
        return getInfo( icol ).getContentClass();
    }

    public String getColumnName( int icol ) {
        return getInfo( icol ).getName();
    }

    public int getColumnCount() {
        return mapGroup_.getKnownKeys().size();
    }

    public int getRowCount() {
        return mapGroup_.getMaps().size();
    }

    public Object getValueAt( int irow, int icol ) {
        return getDescribedValue( irow, icol ).getValue();
    }
}
