package fit.util;

import fit.framework.MetadataTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomStarTable;

/**
 * StarTable implementation based on a <code>MetadataTable</code>.
 *
 * @author   Mark Taylor
 * @since    8 Nov 2006
 */
public class MetaStarTable extends RandomStarTable {

    private final MetadataTable metaTable_;

    /**
     * Constructor.
     *
     * @param  metaTable  metadata table supplying table content
     */
    public MetaStarTable( MetadataTable metaTable ) {
        metaTable_ = metaTable;
    }

    public long getRowCount() {
        return (long) metaTable_.getRowCount();
    }

    public int getColumnCount() {
        return metaTable_.getColumnCount();
    }

    public Object getCell( long irow, int icol ) {
        return metaTable_.getValueAt( checkedLongToInt( irow ), icol );
    }

    public ColumnInfo getColumnInfo( int icol ) {
        return new ColumnInfo( metaTable_.getColumnName( icol ),
                               metaTable_.getColumnClass( icol ), null );
    }
}
