package fit.util;

import fit.framework.Theory;

/**
 * Theory implementation which derives all its behaviour from an existing
 * "base" theory.
 *
 * @author   Mark Taylor
 * @since    15 Nov 2006
 */
public class WrapperTheory implements Theory {

    private final Theory base_;

    /**
     * Constructor.
     *
     * @param  base   base theory
     */
    public WrapperTheory( Theory base ) {
        base_ = base;
    }

    /**
     * Returns the theory on which this one is based.
     *
     * @return  base theory
     */
    public Theory getBase() {
        return base_;
    }

    public int getCount() {
        return base_.getCount();
    }

    public int getFloorIndex( double x ) {
        return base_.getFloorIndex( x );
    }

    public double getX( int i ) {
        return base_.getX( i );
    }

    public double getY( int i ) {
        return base_.getY( i );
    }

    public String getName() {
        return base_.getName();
    }
}
