/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.build.Plot2Example;
import uk.ac.starlink.ttools.build.UsageWriter;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.geom.HealpixDataGeom;
import uk.ac.starlink.ttools.plot2.layer.HealpixPlotter;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.LayerType;
import uk.ac.starlink.ttools.plot2.task.LayerTypeParameter;
import uk.ac.starlink.ttools.plot2.task.ShapeFamilyLayerType;
import uk.ac.starlink.ttools.plot2.task.SimpleLayerType;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class LayerTypeDoc {
    private final boolean basicXml_;
    private final String suffix_;
    private final Map<String, String> examplesMap_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.build");

    public LayerTypeDoc(boolean basicXml) {
        this.basicXml_ = basicXml;
        this.suffix_ = "N";
        this.examplesMap_ = Plot2Example.getExamplesXml();
    }

    public String getXmlDoc(LayerType layerType, PlotType<?, ?> plotType) {
        String exname;
        String exXml;
        String[] posPlaceholderWords;
        String lname = layerType.getName().toLowerCase();
        String layerId = "layer-" + lname;
        int npos = layerType.getCoordGroup().getBasicPositionCount();
        Coord[] extraCoords = layerType.getExtraCoords();
        ConfigKey<?>[] styleKeys = layerType.getStyleKeys();
        boolean hasPos = npos > 0;
        boolean hasExtra = extraCoords.length > 0;
        boolean hasStyle = styleKeys.length > 0;
        boolean hasShade = layerType instanceof ShapeFamilyLayerType;
        boolean hasTable = hasPos | hasExtra;
        StringBuffer sbuf = new StringBuffer().append("<subsubsect id='").append(layerId).append("'>\n").append("<subhead><title><code>").append(lname).append("</code></title></subhead>\n");
        sbuf.append(layerType.getXmlDescription());
        ArrayList<String> usageWords = new ArrayList<String>();
        ArrayList<Object> paramList = new ArrayList<Object>();
        usageWords.add("layer" + this.suffix_ + "=" + lname);
        if (hasStyle) {
            Parameter<?>[] styleParams = LayerTypeParameter.getLayerConfigParams(styleKeys, this.suffix_, false);
            paramList.addAll(Arrays.asList(styleParams));
            usageWords.addAll(LayerTypeParameter.usageWords(styleParams));
        }
        if (hasShade) {
            ChoiceParameter<ShapeMode> shapeModeParam = ((ShapeFamilyLayerType)layerType).createShapeModeParameter(this.suffix_);
            paramList.add(shapeModeParam);
            usageWords.add(LayerTypeParameter.usageWord(shapeModeParam));
        }
        if (hasPos) {
            if (plotType != null) {
                DataGeom geom;
                if (layerType instanceof SimpleLayerType && ((SimpleLayerType)layerType).getPlotter() instanceof HealpixPlotter) {
                    geom = HealpixDataGeom.DUMMY_INSTANCE;
                } else {
                    DataGeom[] geoms = plotType.getPointDataGeoms();
                    assert (geoms.length == 1);
                    geom = geoms[0];
                }
                ArrayList<Object> posParamList = new ArrayList<Object>();
                for (int ipos = 0; ipos < npos; ++ipos) {
                    String posSuffix = npos == 1 ? "" : PlotUtil.getIndexSuffix(ipos);
                    for (Coord posCoord : geom.getPosCoords()) {
                        String sfix = posSuffix + this.suffix_;
                        for (Input input : posCoord.getInputs()) {
                            posParamList.add(AbstractPlot2Task.createDataParameter(input, sfix, false));
                            if (!AbstractPlot2Task.hasDomainMappers(input)) continue;
                            posParamList.add(AbstractPlot2Task.createDomainMapperParameter(input, sfix));
                        }
                    }
                }
                paramList.addAll(posParamList);
                Parameter[] posParams = posParamList.toArray(new Parameter[0]);
                usageWords.addAll(LayerTypeParameter.usageWords(posParams));
                posPlaceholderWords = new String[]{};
            } else {
                posPlaceholderWords = new String[npos];
                for (int ipos = 0; ipos < npos; ++ipos) {
                    String posSuffix = npos == 1 ? "" : PlotUtil.getIndexSuffix(ipos);
                    posPlaceholderWords[ipos] = "<pos-coord-params" + posSuffix + this.suffix_ + ">";
                }
                usageWords.addAll(Arrays.asList(posPlaceholderWords));
            }
        } else {
            posPlaceholderWords = new String[]{};
        }
        if (hasExtra) {
            Parameter<?>[] extraParams = LayerTypeParameter.getCoordParams(extraCoords, this.suffix_, false);
            paramList.addAll(Arrays.asList(extraParams));
            usageWords.addAll(LayerTypeParameter.usageWords(extraParams));
        }
        if (hasTable) {
            Parameter<?>[] tableParams = LayerTypeParameter.getInputParams(this.suffix_);
            paramList.addAll(Arrays.asList(tableParams));
            usageWords.addAll(LayerTypeParameter.usageWords(tableParams));
        }
        sbuf.append("<p>\n").append("<strong>Usage Overview:</strong>\n").append("<verbatim><![CDATA[\n").append(Formatter.formatWords(usageWords, 3)).append("]]></verbatim>\n").append("</p>\n").append("<p>All the parameters listed here\n").append("affect only the relevant layer,\n").append("identified by the suffix\n").append("<code>").append(this.suffix_).append("</code>.\n").append("</p>\n");
        int nppw = posPlaceholderWords.length;
        if (nppw > 0) {
            sbuf.append("<p><dl>\n").append("<dt>Positional Coordinate Parameters:</dt>\n");
            sbuf.append("<dd>").append("<p>The positional coordinates\n");
            for (int i = 0; i < nppw; ++i) {
                if (i > 0) {
                    sbuf.append(", ");
                }
                sbuf.append("<code><![CDATA[").append(posPlaceholderWords[i]).append("]]></code>\n");
            }
            sbuf.append("give ").append(npos == 1 ? "a position " : npos + " positions ").append("for each row of the input table.\n").append("Their form depends on the plot geometry,\n").append("i.e. which plotting command is used.\n").append("For a plane plot ").append("(<ref id='plot2plane'><code>plot2plane</code></ref>)\n").append("the parameters would be\n");
            for (int ipos = 0; ipos < npos; ++ipos) {
                String posSuffix = npos == 1 ? "" : PlotUtil.getIndexSuffix(ipos);
                String sfix = posSuffix + this.suffix_;
                boolean bl = ipos < npos - 1;
                sbuf.append("<code>x").append(sfix).append("</code>").append(bl ? ", " : " and ").append("<code>y").append(sfix).append("</code>").append(bl ? "," : ".").append("\n");
            }
            sbuf.append(PlotUtil.concatLines(new String[]{"The coordinate parameter values are in all cases strings", "interpreted as numeric expressions based on column names.", "These can be column names, fixed values or algebraic", "expressions as described in <ref id='jel'/>.", "</p>"}));
            sbuf.append("</dd>\n").append("</dl>\n").append("</p>\n");
        }
        if ((exXml = this.examplesMap_.get(exname = "layer-" + lname)) != null) {
            sbuf.append("<p>\n").append("<strong>Example:</strong>\n").append("</p>\n").append("<figure>\n").append("<figureimage src='&FIG.plot2-").append(exname).append(";'/>\n").append("</figure>\n").append("<p>").append(exXml).append("</p>\n");
        } else {
            logger_.severe("No example figure for layer type " + lname);
        }
        Collections.sort(paramList, Parameter.BY_NAME);
        if (paramList.size() > 0) {
            sbuf.append("<p><dl>\n");
            for (Parameter parameter : paramList) {
                sbuf.append(UsageWriter.xmlItem(parameter, layerId, this.basicXml_)).append("\n");
            }
            sbuf.append("</dl></p>\n");
        }
        sbuf.append("</subsubsect>\n");
        return sbuf.toString();
    }

    public static TypedPlot2Task<?, ?>[] getPlot2Tasks() throws LoadException {
        ArrayList<TypedPlot2Task> plot2Tasks = new ArrayList<TypedPlot2Task>();
        ObjectFactory<Task> taskFact = Stilts.getTaskFactory();
        for (String nickname : taskFact.getNickNames()) {
            Task task = (Task)taskFact.createObject(nickname);
            if (!(task instanceof TypedPlot2Task)) continue;
            plot2Tasks.add((TypedPlot2Task)task);
        }
        return plot2Tasks.toArray(new TypedPlot2Task[0]);
    }

    public static LayerType[] getLayerTypes() throws LoadException {
        LinkedHashSet<LayerType> ltypes = new LinkedHashSet<LayerType>();
        for (TypedPlot2Task<?, ?> task : LayerTypeDoc.getPlot2Tasks()) {
            ltypes.addAll(LayerTypeDoc.getLayerTypes(task).values());
        }
        return ltypes.toArray(new LayerType[0]);
    }

    private static Map<String, LayerType> getLayerTypes(TypedPlot2Task<?, ?> task) {
        LayerTypeParameter ltParam = AbstractPlot2Task.createLayerTypeParameter("", task.getPlotContext());
        LinkedHashMap<String, LayerType> typeMap = new LinkedHashMap<String, LayerType>();
        for (LayerType ltype : (LayerType[])ltParam.getOptions()) {
            typeMap.put(ltype.getName(), ltype);
        }
        return typeMap;
    }

    public static String layerTypeRef(LayerType ltype) {
        String ltname = ltype.getName().toLowerCase();
        return new StringBuffer().append("<ref id='layer-").append(ltname).append("' plaintextref='yes'><code>").append(ltname).append("</code></ref>").toString();
    }

    public static void main(String[] args) throws LoadException {
        String usage = new StringBuffer().append("\n   ").append("Usage: ").append(LayerTypeDoc.class.getName()).append(" [-doc]").append(" [-basicxml]").append(" [<layer-name> ...]").append("\n").toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean doc = false;
        boolean basicXml = false;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-doc")) {
                it.remove();
                doc = true;
            }
            if (arg.equals("-basicxml")) {
                it.remove();
                basicXml = true;
            }
            if (!arg.startsWith("-h") && !arg.startsWith("--h")) continue;
            it.remove();
            System.err.println(usage);
            return;
        }
        TypedPlot2Task<?, ?>[] tasks = LayerTypeDoc.getPlot2Tasks();
        LinkedHashMap<String, LayerType> typeMap = new LinkedHashMap<String, LayerType>();
        LinkedHashMap taskMap = new LinkedHashMap();
        for (TypedPlot2Task<?, ?> task : tasks) {
            for (Map.Entry<String, LayerType> entry : LayerTypeDoc.getLayerTypes(task).entrySet()) {
                String lname = entry.getKey();
                LayerType ltype = entry.getValue();
                if (!taskMap.containsKey(lname)) {
                    taskMap.put(lname, new HashSet());
                }
                ((Set)taskMap.get(lname)).add(task);
                if (typeMap.containsKey(lname)) continue;
                typeMap.put(lname, ltype);
            }
        }
        if (argList.size() > 0) {
            typeMap.keySet().retainAll(argList);
        }
        PrintStream out = System.out;
        if (doc) {
            out.println("<doc>");
        }
        LayerTypeDoc doccer = new LayerTypeDoc(basicXml);
        for (Map.Entry entry : typeMap.entrySet()) {
            String lname = (String)entry.getKey();
            LayerType ltype = (LayerType)entry.getValue();
            Set ltasks = (Set)taskMap.get(lname);
            PlotType plotType = ltasks != null && ltasks.size() == 1 ? ((TypedPlot2Task)ltasks.iterator().next()).getPlotType() : null;
            out.println(doccer.getXmlDoc(ltype, plotType));
        }
        if (doc) {
            out.println("</doc>");
        }
    }
}

