/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.Documented;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableScheme;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.Stilts;

public class SchemeDoc {
    private final boolean requiresDoc_;

    public SchemeDoc(boolean requiresDoc) {
        this.requiresDoc_ = requiresDoc;
    }

    public String getXmlDoc(TableScheme scheme) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        String name = scheme.getSchemeName();
        sbuf.append("<subsubsect id='scheme-").append(name).append("'>\n").append("<subhead><title><code>").append(name).append("</code></title></subhead>\n").append("<p>Usage: <code><![CDATA[:").append(name).append(":").append(scheme.getSchemeUsage()).append("]]></code>\n").append("</p>\n");
        if (scheme instanceof Documented) {
            sbuf.append(DocUtils.getXmlDescription((Documented)scheme));
        } else if (this.requiresDoc_) {
            throw new IllegalArgumentException("Scheme does not implement Documented");
        }
        String exSpec = scheme.getExampleSpecification();
        if (exSpec != null) {
            sbuf.append("<p>Example:\n").append("<verbatim><![CDATA[\n").append(":").append(scheme.getSchemeName()).append(":").append(exSpec).append("\n").append(Tables.tableToString((StarTable)scheme.createTable(exSpec), null)).append("\n]]></verbatim>\n").append("</p>\n");
        }
        sbuf.append("</subsubsect>\n");
        return sbuf.toString();
    }

    public static void main(String[] args) throws IOException {
        String usage = "\n   Usage: " + SchemeDoc.class.getName() + " [-[no]stil] [-[no]stilts]\n";
        boolean hasStil = true;
        boolean hasStilts = false;
        for (String arg : args) {
            if ("-stil".equals(arg)) {
                hasStil = true;
                continue;
            }
            if ("-nostil".equals(arg)) {
                hasStil = false;
                continue;
            }
            if ("-stilts".equals(arg)) {
                hasStilts = true;
                continue;
            }
            if ("-nostilts".equals(arg)) {
                hasStilts = false;
                continue;
            }
            System.err.println(usage);
            System.exit(1);
        }
        ArrayList<Object> schemes = new ArrayList<Object>();
        if (hasStilts) {
            schemes.addAll(Arrays.asList(Stilts.getStandardSchemes()));
        }
        if (hasStil) {
            schemes.addAll(new StarTableFactory().getSchemes().values());
        }
        PrintStream out = System.out;
        SchemeDoc sdoc = new SchemeDoc(true);
        for (TableScheme tableScheme : schemes) {
            out.println(sdoc.getXmlDoc(tableScheme));
        }
    }
}

