/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.build.DocletOutput;
import uk.ac.starlink.ttools.build.DocletUtil;
import uk.ac.starlink.ttools.build.HideDoc;
import uk.ac.starlink.ttools.build.HtmlDocletOutput;
import uk.ac.starlink.ttools.build.XmlDocletOutput;
import uk.ac.starlink.ttools.gui.DocNames;

public class SunDoclet {
    private final RootDoc root_;
    private final DocletOutput output_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.build");

    public SunDoclet(RootDoc root, DocletOutput output) {
        this.root_ = root;
        this.output_ = output;
    }

    public boolean process() throws IOException {
        Object[] classes = this.root_.classes();
        Arrays.sort(classes);
        this.output_.startOutput();
        for (int i = 0; i < classes.length; ++i) {
            Object clazz = classes[i];
            if (!clazz.isPublic()) continue;
            this.processClass((ClassDoc)clazz);
        }
        this.output_.endOutput();
        return true;
    }

    private void processClass(ClassDoc clazz) throws IOException {
        if (SunDoclet.isDocumentable((ProgramElementDoc)clazz)) {
            this.output_.startClass(clazz.qualifiedName(), SunDoclet.firstSentence((Doc)clazz), clazz.commentText());
            MethodDoc[] methods = clazz.methods();
            for (int i = 0; i < methods.length; ++i) {
                MethodDoc method = methods[i];
                if (!SunDoclet.isDocumentable((ProgramElementDoc)method)) continue;
                this.processMethod(method);
            }
            FieldDoc[] fields = clazz.fields();
            for (int i = 0; i < fields.length; ++i) {
                FieldDoc field = fields[i];
                if (!SunDoclet.isDocumentable((ProgramElementDoc)field)) continue;
                this.processField(field);
            }
            this.output_.endClass();
        }
    }

    private void processField(FieldDoc field) throws IOException {
        this.output_.startMember(field.name(), "Constant", field.name(), field.commentText());
        this.output_.outMemberItem("Type", SunDoclet.typeString(field.type()));
        Object value = field.constantValue();
        if (value != null) {
            this.output_.outMemberItem("Value", value.toString());
        }
        this.output_.endMember();
    }

    private void processMethod(MethodDoc method) throws IOException {
        String type;
        ClassDoc clazz = method.containingClass();
        boolean isVararg = method.isVarArgs();
        Parameter[] params = method.parameters();
        StringBuffer paramList = new StringBuffer("( ");
        for (int i = 0; i < params.length; ++i) {
            String pname = params[i].name();
            if (i > 0) {
                paramList.append(", ");
            }
            paramList.append(pname);
        }
        if (isVararg) {
            paramList.append(", ...");
        }
        paramList.append(" )");
        ParamTag[] ptags = method.paramTags();
        ArrayList<1> varList = new ArrayList<1>();
        for (int i = 0; i < params.length; ++i) {
            Parameter[] param = params[i];
            final String pname = param.name();
            String comment = null;
            for (int j = 0; j < ptags.length; ++j) {
                if (!pname.equals(ptags[j].parameterName())) continue;
                if (comment == null) {
                    comment = ptags[j].parameterComment();
                    continue;
                }
                logger_.warning(clazz + "." + method + ": multiple tags for parameter " + pname);
            }
            final String comment0 = comment;
            if (comment0 == null) {
                logger_.warning(clazz + "." + method + ": no tag for parameter " + pname);
            }
            type = SunDoclet.varargTypeString(param.type(), isVararg && i == params.length - 1);
            varList.add(new DocletOutput.DocVariable(){

                @Override
                public String getName() {
                    return pname;
                }

                @Override
                public String getType() {
                    return type;
                }

                @Override
                public String getCommentText() {
                    return comment0;
                }
            });
        }
        assert (varList.size() == params.length);
        StringBuffer idBuf = new StringBuffer(method.name());
        for (Parameter param : params) {
            idBuf.append('-');
            type = param.type();
            idBuf.append(DocNames.typeNameToWord(type.qualifiedTypeName()));
            String dim = type.dimension();
            if (dim == null) continue;
            idBuf.append(dim.replaceAll("\\[\\]", ","));
        }
        String methodId = idBuf.toString();
        String retdesc = null;
        boolean isVoid = "void".equals(method.returnType().qualifiedTypeName());
        Tag[] retags = method.tags("return");
        if (!isVoid) {
            if (retags.length != 1) {
                logger_.warning(clazz + "." + method + ": " + retags.length + " @return tags");
            } else {
                retdesc = retags[0].text();
            }
        }
        Tag[] extags = method.tags("example");
        String[] examples = new String[extags.length];
        for (int i = 0; i < extags.length; ++i) {
            examples[i] = extags[i].text();
        }
        ArrayList<String> sees = new ArrayList<String>();
        for (Tag seeTag : method.tags("see")) {
            if (!(seeTag instanceof SeeTag)) continue;
            sees.add(seeTag.text());
        }
        Type rtype = method.returnType();
        this.output_.startMember(method.name() + paramList, "Function", methodId, method.commentText());
        if (varList.size() > 0) {
            this.output_.outParameters(varList.toArray(new DocletOutput.DocVariable[0]));
        }
        if (!isVoid) {
            this.output_.outReturn(SunDoclet.typeString(rtype), retdesc);
        }
        if (examples.length > 1) {
            this.output_.outExamples("Examples", examples);
        } else if (examples.length > 0) {
            this.output_.outExamples("Example", examples);
        }
        if (sees.size() > 0) {
            this.output_.outSees("See Also", sees.toArray(new String[0]));
        }
        String signature = new StringBuffer().append("<code>").append(rtype.toString().replaceAll("^.*\\.", "")).append(" ").append(method.name()).append(method.signature().replaceAll("\\w[\\w\\.]*\\.(\\w+)", "$1")).append("</code>").toString();
        this.output_.outMemberItem("Signature", signature);
        this.output_.endMember();
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    private static boolean isDocumentable(ProgramElementDoc pel) {
        if (!pel.isPublic()) {
            return false;
        }
        if ((pel instanceof FieldDoc || pel instanceof MethodDoc) && !pel.isStatic()) {
            return false;
        }
        if (pel instanceof FieldDoc && !pel.isFinal()) {
            return false;
        }
        for (AnnotationDesc adesc : pel.annotations()) {
            if (!HideDoc.class.getName().equals(adesc.annotationType().qualifiedName())) continue;
            return false;
        }
        return true;
    }

    private static String typeString(Type type) {
        return SunDoclet.varargTypeString(type, false);
    }

    private static String varargTypeString(Type type, boolean isVararg) {
        String tdim = type.dimension();
        if (isVararg) {
            if (tdim.startsWith("[]")) {
                tdim = tdim.substring(2);
            } else {
                isVararg = false;
            }
        }
        String pre = tdim.replaceAll("\\[\\]", "array of ");
        String post = isVararg ? ", one or more" : "";
        String typetxt = DocletUtil.getScalarTypeName(type.qualifiedTypeName());
        if (typetxt == null) {
            typetxt = type.qualifiedTypeName().replaceFirst(".*[.$]", "");
        }
        return pre + typetxt + post;
    }

    private static String firstSentence(Doc doc) {
        StringBuffer sbuf = new StringBuffer();
        for (Tag tag : doc.firstSentenceTags()) {
            if (!"Text".equals(tag.kind())) continue;
            sbuf.append(tag.text());
        }
        return sbuf.toString();
    }

    public static class Html {
        public static int optionLength(String option) {
            if (option.equals("-d")) {
                return 2;
            }
            if (option.equals("-headings")) {
                return 1;
            }
            return 0;
        }

        public static boolean start(RootDoc root) throws IOException {
            String[][] options = root.options();
            File baseDir = new File(".");
            boolean isHeadings = false;
            for (String[] opts : options) {
                String opt = opts[0];
                if ("-d".equals(opt)) {
                    baseDir = new File(opts[1]);
                }
                if (!"-headings".equals(opt)) continue;
                isHeadings = true;
            }
            HtmlDocletOutput output = new HtmlDocletOutput(baseDir, isHeadings);
            return new SunDoclet(root, output).process();
        }

        public static LanguageVersion languageVersion() {
            return SunDoclet.languageVersion();
        }
    }

    public static class Xml {
        public static int optionLength(String option) {
            if (option.equals("-o")) {
                return 2;
            }
            if (option.equals("-headonly")) {
                return 1;
            }
            return 0;
        }

        public static boolean start(RootDoc root) throws IOException {
            String[][] options = root.options();
            String outloc = null;
            boolean headOnly = false;
            for (String[] opts : options) {
                String opt = opts[0];
                if ("-o".equals(opt)) {
                    outloc = opts[1];
                }
                if (!"-headonly".equals(opt)) continue;
                headOnly = true;
            }
            PrintStream outStream = outloc == null || "-".equals(outloc) ? System.out : new FileOutputStream(outloc);
            XmlDocletOutput output = new XmlDocletOutput(outStream, headOnly, s -> s.replaceFirst(".*[.]", ""));
            return new SunDoclet(root, output).process();
        }

        public static LanguageVersion languageVersion() {
            return SunDoclet.languageVersion();
        }
    }
}

