/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.build.DocletOutput;
import uk.ac.starlink.ttools.build.MemberIdSet;

public class XmlDocletOutput
implements DocletOutput {
    private final BufferedWriter out_;
    private final boolean headOnly_;
    private final Function<String, String> clazzToId_;
    private MemberIdSet memberIdSet_;
    private String clazzId_;
    private boolean skipMembers_;
    private boolean discardOutput_;
    private static final Pattern P_PATTERN = Pattern.compile("\\s*(</*[Pp]>)?\\s+(<[Pp]>)\\s*");

    public XmlDocletOutput(OutputStream out, boolean headOnly, Function<String, String> clazzToId) {
        this.out_ = new BufferedWriter(new OutputStreamWriter(out));
        this.headOnly_ = headOnly;
        this.clazzToId_ = clazzToId;
    }

    @Override
    public void startOutput() throws IOException {
        if (this.headOnly_) {
            this.out("<dl>");
        }
    }

    @Override
    public void endOutput() throws IOException {
        if (this.headOnly_) {
            this.out("</dl>");
        }
        this.out_.flush();
    }

    @Override
    public void startClass(String className, String firstSentence, String fullDescription) throws IOException {
        String comment;
        String shortName = className.replaceFirst("^.*[.]", "");
        this.clazzId_ = this.clazzToId_.apply(className);
        this.memberIdSet_ = new MemberIdSet();
        if (this.headOnly_) {
            this.out("<dt><ref id='" + this.clazzId_ + "'>" + shortName + "</ref></dt>");
            this.out("<dd>");
        } else {
            this.out("<subsubsect id='" + this.clazzId_ + "'>");
            this.out("<subhead><title>" + shortName + "</title></subhead>");
        }
        String string = comment = this.headOnly_ ? firstSentence : fullDescription;
        if (comment != null) {
            this.out(XmlDocletOutput.doctorText(comment));
        }
        if (this.headOnly_ && !this.discardOutput_) {
            this.skipMembers_ = true;
            this.discardOutput_ = true;
        }
        this.out("<p><dl>");
    }

    @Override
    public void endClass() throws IOException {
        this.clazzId_ = null;
        this.memberIdSet_ = null;
        this.out("</dl></p>");
        if (this.skipMembers_) {
            this.discardOutput_ = false;
            this.skipMembers_ = false;
        }
        if (this.headOnly_) {
            this.out("</dd>");
        } else {
            this.out("</subsubsect>");
        }
        this.discardOutput_ = false;
    }

    @Override
    public void startMember(String memberName, String memberType, String memberId, String description) throws IOException {
        StringBuffer sbuf = new StringBuffer("<dt");
        String xmlId = this.memberIdSet_.getUniqueId(memberName);
        if (xmlId != null) {
            sbuf.append(" id='").append(this.clazzId_).append("-").append(xmlId).append("'");
        }
        sbuf.append("><code>").append(memberName).append("</code></dt>");
        this.out(sbuf.toString());
        this.out("<dd>");
        this.out(XmlDocletOutput.doctorText(description));
        this.out("<p><ul>");
    }

    @Override
    public void endMember() throws IOException {
        this.out("</ul></p>");
        this.out("</dd>");
    }

    @Override
    public void outMemberItem(String name, String val) throws IOException {
    }

    @Override
    public void outParameters(DocletOutput.DocVariable[] params) throws IOException {
        this.out("<li>Parameters:");
        this.out("<ul>");
        for (DocletOutput.DocVariable param : params) {
            StringBuffer buf = new StringBuffer();
            buf.append("<li><code>").append(param.getName()).append("</code> ").append("<em>(").append(param.getType()).append(")</em>");
            String comment = param.getCommentText();
            if (comment != null) {
                buf.append(": " + comment);
            }
            buf.append("</li>");
            this.out(buf.toString());
        }
        this.out("</ul>");
        this.out("</li>");
    }

    @Override
    public void outReturn(String type, String comment) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("<li>Return value").append("<ul><li>").append("<em>(").append(type).append(")</em>");
        if (comment != null) {
            buf.append(": ").append(comment);
        }
        buf.append("</li></ul>");
        buf.append("</li>");
        this.out(buf.toString());
    }

    @Override
    public void outExamples(String heading, String[] examples) throws IOException {
        this.out("<li>" + heading + ":");
        this.out("<ul>");
        for (String example : examples) {
            this.out("<li>" + example + "</li>");
        }
        this.out("</ul>");
        this.out("</li>");
    }

    @Override
    public void outSees(String heading, String[] sees) throws IOException {
        List seeTxts = Arrays.stream(sees).map(t -> XmlDocletOutput.formatSeeText(t)).filter(t -> t != null).collect(Collectors.toList());
        if (seeTxts.size() > 0) {
            this.out("<li>" + heading + ":");
            this.out("<ul>");
            for (String seeTxt : seeTxts) {
                this.out("<li>" + seeTxt + "</li>");
            }
            this.out("</ul>");
            this.out("</li>");
        }
    }

    private void out(String line) throws IOException {
        if (!this.discardOutput_) {
            this.out_.write(line);
            this.out_.write(10);
        }
    }

    private static String formatSeeText(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        if ((txt = txt.trim().replaceAll("\\s+", " ")).startsWith("<a")) {
            return txt.replaceAll("^<a ", "<webref ").replaceAll("</a>", "</webref>").replaceAll("href=", "url=");
        }
        return null;
    }

    private static String doctorText(String text) {
        text = text.replaceAll("<a href=", "<webref plaintextref='yes' url=").replaceAll("</a>", "</webref>").replaceAll("<pre>", "<verbatim>").replaceAll("</pre>", "</verbatim>");
        return XmlDocletOutput.pWrap(text);
    }

    private static String pWrap(String text) {
        String[] params = P_PATTERN.split(text);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            sbuf.append("<p>" + params[i] + "</p>\n");
        }
        return sbuf.toString();
    }
}

