/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.EmptyStarTable;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.OnceRowPipe;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowListStarTable;
import uk.ac.starlink.table.RowPipe;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.SelectorStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.ConeErrorPolicy;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.ConeResultRowSequence;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.cone.ParallelResultRowSequence;
import uk.ac.starlink.ttools.cone.QuerySequenceFactory;
import uk.ac.starlink.ttools.cone.SequentialResultRowSequence;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.filter.CalculatorColumnSupplement;
import uk.ac.starlink.ttools.filter.ColumnSupplement;
import uk.ac.starlink.ttools.filter.PermutedColumnSupplement;
import uk.ac.starlink.ttools.filter.SupplementData;
import uk.ac.starlink.ttools.func.CoordsDegrees;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;
import uk.ac.starlink.ttools.task.TableProducer;

public class ConeMatcher {
    private final ConeSearcher coneSearcher_;
    private final ConeErrorPolicy errAct_;
    private final TableProducer inProd_;
    private final QuerySequenceFactory qsFact_;
    private final int parallelism_;
    private final boolean bestOnly_;
    private final Coverage coverage_;
    private final boolean includeBlanks_;
    private final boolean distFilter_;
    private final String copyColIdList_;
    private final JoinFixAction inFixAct_;
    private final JoinFixAction coneFixAct_;
    private final String distanceCol_;
    private boolean streamOutput_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");
    private static final ValueInfo DISTANCE_INFO = new DefaultValueInfo("Distance", Double.class, "Angular separation between query position and result position");

    public ConeMatcher(ConeSearcher coneSearcher, ConeErrorPolicy errAct, TableProducer inProd, QuerySequenceFactory qsFact, boolean bestOnly) {
        this(coneSearcher, errAct, inProd, qsFact, bestOnly, null, true, false, 1, "*", DISTANCE_INFO.getName(), JoinFixAction.NO_ACTION, JoinFixAction.makeRenameDuplicatesAction((String)"_1", (boolean)false, (boolean)false));
    }

    public ConeMatcher(ConeSearcher coneSearcher, ConeErrorPolicy errAct, TableProducer inProd, QuerySequenceFactory qsFact, boolean bestOnly, Coverage coverage, boolean includeBlanks, boolean distFilter, int parallelism, String copyColIdList, String distanceCol, JoinFixAction inFixAct, JoinFixAction coneFixAct) {
        this.coneSearcher_ = coneSearcher;
        this.errAct_ = errAct;
        this.inProd_ = inProd;
        this.qsFact_ = qsFact;
        this.bestOnly_ = bestOnly;
        this.coverage_ = coverage;
        this.includeBlanks_ = includeBlanks;
        this.distFilter_ = distFilter;
        this.parallelism_ = parallelism;
        this.copyColIdList_ = copyColIdList;
        this.distanceCol_ = distanceCol;
        this.inFixAct_ = inFixAct;
        this.coneFixAct_ = coneFixAct;
    }

    public void setStreamOutput(boolean streamOutput) {
        this.streamOutput_ = streamOutput;
    }

    public ConeWorker createConeWorker() throws IOException, TaskException {
        StarTable inTable = this.inProd_.getTable();
        ConeQueryRowSequence querySeq = this.qsFact_.createQuerySequence(inTable);
        if (this.coverage_ != null) {
            try {
                this.coverage_.initCoverage();
            }
            catch (IOException e) {
                logger_.warning("Coverage initialisation failed: " + e);
            }
        }
        ConeResultRowSequence resultSeq = this.parallelism_ == 1 ? new SequentialResultRowSequence(querySeq, this.coneSearcher_, this.errAct_, this.coverage_, this.bestOnly_, this.distFilter_, this.distanceCol_){

            @Override
            public void close() throws IOException {
                super.close();
                ConeMatcher.this.coneSearcher_.close();
            }
        } : new ParallelResultRowSequence(querySeq, this.coneSearcher_, this.errAct_, this.coverage_, this.bestOnly_, this.distFilter_, this.distanceCol_, this.parallelism_){

            @Override
            public void close() throws IOException {
                super.close();
                ConeMatcher.this.coneSearcher_.close();
            }
        };
        int[] iCopyCols = this.copyColIdList_ == null || this.copyColIdList_.trim().length() == 0 ? new int[]{} : new ColumnIdentifier(inTable).getColumnIndices(this.copyColIdList_);
        return new ConeWorker(inTable, resultSeq, iCopyCols, this.includeBlanks_, this.distanceCol_ != null && this.distanceCol_.trim().length() > 0 ? 1 : 0, this.inFixAct_, this.coneFixAct_, JoinFixAction.NO_ACTION, this.streamOutput_);
    }

    public static StarTable getConeResult(ConeSearcher coneSearcher, ConeErrorPolicy errAct, boolean bestOnly, boolean distFilter, String distanceCol, double ra0, double dec0, final double sr) throws IOException {
        Object filteredResultWithDistance;
        StarTable result;
        if (Double.isNaN(ra0) || Double.isNaN(dec0)) {
            logger_.warning("Invalid search parameters");
            return null;
        }
        distFilter = distFilter && sr > 0.0;
        logger_.info("Cone: ra=" + ra0 + "; dec=" + dec0 + "; sr=" + sr);
        try {
            result = errAct.performConeSearch(coneSearcher, ra0, dec0, sr);
        }
        catch (InterruptedException e) {
            throw new IOException("Thread interrupted");
        }
        if (result == null) {
            return null;
        }
        int ira = coneSearcher.getRaIndex(result);
        int idec = coneSearcher.getDecIndex(result);
        ColumnInfo distInfo = new ColumnInfo(DISTANCE_INFO);
        if (distanceCol != null && distanceCol.trim().length() > 0) {
            distInfo.setName(distanceCol);
        }
        StarTable resultWithDistance = ConeMatcher.addDistanceColumn(result, ira, idec, ra0, dec0, distInfo);
        assert (resultWithDistance.getColumnCount() == result.getColumnCount() + 1);
        final int idist = resultWithDistance.getColumnCount() - 1;
        assert (resultWithDistance.getColumnInfo(idist).getName().equals(distInfo.getName()));
        if (ira < 0 || idec < 0) {
            logger_.warning("Can't locate RA/DEC in output table - no post-filtering or distance calculation");
            filteredResultWithDistance = resultWithDistance;
        } else if (bestOnly) {
            RowSequence rseq = resultWithDistance.getRowSequence();
            double bestDist = Double.NaN;
            Object[] bestRow = null;
            while (rseq.next()) {
                double dist;
                Object distObj = rseq.getCell(idist);
                assert (distObj == null || distObj instanceof Double);
                if (!(distObj instanceof Number) || !((dist = ((Number)distObj).doubleValue()) <= sr) && distFilter || !(dist < bestDist) && !Double.isNaN(bestDist)) continue;
                bestDist = dist;
                bestRow = (Object[])rseq.getRow().clone();
            }
            filteredResultWithDistance = new RowListStarTable(resultWithDistance);
            if (!Double.isNaN(bestDist)) {
                ((RowListStarTable)filteredResultWithDistance).addRow(bestRow);
            }
        } else {
            filteredResultWithDistance = distFilter ? new SelectorStarTable(resultWithDistance){

                public boolean isIncluded(RowSequence rseq) throws IOException {
                    Object distObj = rseq.getCell(idist);
                    assert (distObj == null || distObj instanceof Double);
                    return distObj instanceof Number && ((Number)distObj).doubleValue() <= sr;
                }
            } : resultWithDistance;
        }
        if (distanceCol != null && distanceCol.trim().length() > 0) {
            return filteredResultWithDistance;
        }
        assert (idist == filteredResultWithDistance.getColumnCount() - 1);
        assert (idist == result.getColumnCount());
        int[] colMap = new int[idist];
        for (int icol = 0; icol < idist; ++icol) {
            colMap[icol] = icol;
        }
        return new ColumnPermutedStarTable(filteredResultWithDistance, colMap, true);
    }

    private static StarTable addDistanceColumn(StarTable inTable, int ira, int idec, final double ra0, final double dec0, ColumnInfo distInfo) {
        ColumnSupplement distSup;
        if (!distInfo.getContentClass().isAssignableFrom(Double.class)) {
            throw new IllegalArgumentException("Bad column info type");
        }
        int ncolIn = inTable.getColumnCount();
        ColumnInfo[] distCols = new ColumnInfo[]{distInfo};
        if (ira < 0 || idec < 0) {
            Object[] blankRow = new Object[]{Double.NaN};
            distSup = new ConstantColumnSupplement(distCols, blankRow);
        } else {
            final double raUnit = ConeMatcher.getAngleUnit(inTable.getColumnInfo(ira).getUnitString());
            final double decUnit = ConeMatcher.getAngleUnit(inTable.getColumnInfo(idec).getUnitString());
            PermutedColumnSupplement radecSup = new PermutedColumnSupplement(inTable, new int[]{ira, idec});
            distSup = new CalculatorColumnSupplement(radecSup, distCols){

                @Override
                protected Object[] calculate(Object[] inValues) {
                    double ra1 = 4.getDouble(inValues[0]) * raUnit;
                    double dec1 = 4.getDouble(inValues[1]) * decUnit;
                    double dist = CoordsDegrees.skyDistanceDegrees(ra0, dec0, ra1, dec1);
                    return new Object[]{dist};
                }
            };
        }
        return new AddColumnsTable(inTable, distSup);
    }

    private static double getAngleUnit(String unitString) {
        if (unitString == null || unitString.trim().length() == 0) {
            return 1.0;
        }
        if (unitString.toLowerCase().startsWith("deg")) {
            return 1.0;
        }
        if (unitString.toLowerCase().startsWith("rad")) {
            return 57.29577951308232;
        }
        return Double.NaN;
    }

    static {
        ((DefaultValueInfo)DISTANCE_INFO).setUnitString("deg");
        ((DefaultValueInfo)DISTANCE_INFO).setUCD("pos.angDistance");
    }

    private static class ConstantColumnSupplement
    implements ColumnSupplement {
        private final ColumnInfo[] colInfos_;
        private final Object[] row_;

        ConstantColumnSupplement(ColumnInfo[] colInfos, Object[] row) {
            this.colInfos_ = colInfos;
            this.row_ = row;
        }

        @Override
        public int getColumnCount() {
            return this.colInfos_.length;
        }

        @Override
        public ColumnInfo getColumnInfo(int icol) {
            return this.colInfos_[icol];
        }

        @Override
        public Object getCell(long irow, int icol) {
            return this.row_[icol];
        }

        @Override
        public Object[] getRow(long irow) {
            return (Object[])this.row_.clone();
        }

        @Override
        public SupplementData createSupplementData(RowData rdata) {
            return new SupplementData(){

                @Override
                public Object getCell(long irow, int icol) {
                    return row_[icol];
                }

                @Override
                public Object[] getRow(long irow) {
                    return (Object[])row_.clone();
                }
            };
        }
    }

    public static class ConeWorker
    implements Runnable,
    TableProducer {
        private final StarTable inTable_;
        private final ConeResultRowSequence resultSeq_;
        private final int[] iCopyCols_;
        private final boolean includeBlanks_;
        private final int extraCols_;
        private final JoinFixAction inFixAct_;
        private final JoinFixAction coneFixAct_;
        private final JoinFixAction extrasFixAct_;
        private final boolean strmOut_;
        private final RowPipe rowPipe_;

        private ConeWorker(StarTable inTable, ConeResultRowSequence resultSeq, int[] iCopyCols, boolean includeBlanks, int extraCols, JoinFixAction inFixAct, JoinFixAction coneFixAct, JoinFixAction extrasFixAct, boolean strmOut) {
            this.inTable_ = inTable;
            this.resultSeq_ = resultSeq;
            this.iCopyCols_ = iCopyCols;
            this.includeBlanks_ = includeBlanks;
            this.extraCols_ = extraCols;
            this.inFixAct_ = inFixAct;
            this.coneFixAct_ = coneFixAct;
            this.extrasFixAct_ = extrasFixAct;
            this.strmOut_ = strmOut;
            this.rowPipe_ = new OnceRowPipe();
        }

        @Override
        public StarTable getTable() throws IOException {
            StarTable streamTable = this.rowPipe_.waitForStarTable();
            return this.strmOut_ ? streamTable : Tables.randomTable((StarTable)streamTable);
        }

        @Override
        public void run() {
            try {
                this.multiCone();
            }
            catch (IOException e) {
                this.rowPipe_.setError(e);
            }
            catch (Throwable e) {
                this.rowPipe_.setError((IOException)new IOException("Read error: " + e.getMessage()).initCause(e));
            }
            finally {
                try {
                    this.rowPipe_.endRows();
                }
                catch (IOException e) {}
                try {
                    this.resultSeq_.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void multiCone() throws IOException {
            int ncIn = this.iCopyCols_.length;
            int ncCone = -1;
            ArrayList<Object[]> inQueue = null;
            int irow = 0;
            while (this.resultSeq_.next()) {
                StarTable result = this.resultSeq_.getConeResult();
                if (result != null) {
                    Object[] row;
                    int nc = result.getColumnCount();
                    if (ncCone < 0) {
                        ncCone = nc;
                        this.rowPipe_.acceptMetadata(this.getMetadata(result));
                        if (inQueue != null) {
                            for (Object[] inRow : inQueue) {
                                Object[] outRow = new Object[ncIn + ncCone];
                                System.arraycopy(inRow, 0, outRow, 0, ncIn);
                                this.rowPipe_.acceptRow(outRow);
                            }
                            inQueue = null;
                        }
                    } else if (nc != ncCone) {
                        String msg = "Inconsistent column counts from different cone search invocations (" + nc + " != " + ncCone + ")";
                        throw new IOException(msg);
                    }
                    int nr = 0;
                    try (RowSequence rSeq = result.getRowSequence();){
                        while (rSeq.next()) {
                            ++nr;
                            row = new Object[ncIn + ncCone];
                            this.copyInCells(row);
                            for (int ic = 0; ic < ncCone; ++ic) {
                                row[ncIn + ic] = rSeq.getCell(ic);
                            }
                            this.rowPipe_.acceptRow(row);
                        }
                    }
                    if (nr == 0 && this.includeBlanks_) {
                        row = new Object[ncIn + ncCone];
                        this.copyInCells(row);
                        this.rowPipe_.acceptRow(row);
                    }
                    logger_.info("Row " + irow + ": got " + nr + (nr == 1 ? " match" : " matches"));
                } else {
                    if (this.includeBlanks_) {
                        if (ncCone < 0) {
                            Object[] inRow = new Object[ncIn];
                            this.copyInCells(inRow);
                            if (inQueue == null) {
                                inQueue = new ArrayList<Object[]>();
                            }
                            inQueue.add(inRow);
                        } else {
                            Object[] row = new Object[ncIn + ncCone];
                            this.copyInCells(row);
                            this.rowPipe_.acceptRow(row);
                        }
                    }
                    logger_.info("Row " + irow + ": got no matches");
                }
                ++irow;
            }
            if (ncCone < 0) {
                String msg = "No results were found and no table metadata could be gathered.  Sorry.";
                logger_.warning(msg);
                EmptyStarTable result0 = new EmptyStarTable();
                DefaultValueInfo msgInfo = new DefaultValueInfo("Message", String.class, "Multicone execution report");
                result0.getParameters().add(new DescribedValue((ValueInfo)msgInfo, (Object)msg));
                this.rowPipe_.acceptMetadata((StarTable)new EmptyStarTable());
            }
        }

        private void copyInCells(Object[] row) throws IOException {
            int ncIn = this.iCopyCols_.length;
            for (int ic = 0; ic < ncIn; ++ic) {
                row[ic] = this.resultSeq_.getCell(this.iCopyCols_[ic]);
            }
        }

        private StarTable getMetadata(StarTable coneResult) {
            int icol;
            int icol2;
            int ncol = this.iCopyCols_.length + coneResult.getColumnCount();
            ColumnInfo[] infos = new ColumnInfo[ncol];
            for (icol2 = 0; icol2 < this.iCopyCols_.length; ++icol2) {
                infos[icol2] = this.inTable_.getColumnInfo(this.iCopyCols_[icol2]);
            }
            for (icol2 = 0; icol2 < coneResult.getColumnCount(); ++icol2) {
                infos[icol2 + this.iCopyCols_.length] = coneResult.getColumnInfo(icol2);
            }
            ArrayList<String> colNames = new ArrayList<String>();
            for (icol = 0; icol < infos.length; ++icol) {
                colNames.add(infos[icol].getName());
            }
            for (icol = 0; icol < infos.length; ++icol) {
                JoinFixAction fixAct = icol < this.iCopyCols_.length ? this.inFixAct_ : (icol < infos.length - this.extraCols_ ? this.coneFixAct_ : this.extrasFixAct_);
                String name = infos[icol].getName();
                assert (name.equals(colNames.get(icol)));
                colNames.set(icol, null);
                String fixName = fixAct.getFixedName(name, colNames);
                colNames.set(icol, name);
                if (fixName.equals(name)) continue;
                ColumnInfo info = new ColumnInfo((ValueInfo)infos[icol]);
                info.setName(fixName);
                infos[icol] = info;
            }
            return new RowListStarTable(infos){

                public long getRowCount() {
                    return -1L;
                }

                public boolean isRandom() {
                    return false;
                }
            };
        }
    }
}

