/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import cds.healpix.FlatHashIterator;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.cone.SkyTiling;

public class HealpixTiling
implements SkyTiling {
    private final int k_;
    private final boolean nest_;
    private final HashComputer hasher_;
    private final HealpixNested hnested_;
    public static final int MAX_LEVEL = 29;

    public HealpixTiling(int k, boolean nest) {
        if (k > 29) {
            throw new IllegalArgumentException("k " + k + " too large");
        }
        this.k_ = k;
        this.nest_ = nest;
        this.hasher_ = Healpix.getNestedFast((int)k);
        this.hnested_ = Healpix.getNested((int)k);
    }

    public int getHealpixK() {
        return this.k_;
    }

    public boolean isNest() {
        return this.nest_;
    }

    @Override
    public long getPixelCount() {
        return 12L << 2 * this.k_;
    }

    @Override
    public ValueInfo getIndexInfo() {
        String name = "hpx" + this.k_;
        Class clazz = this.k_ <= 13 ? Integer.class : Long.class;
        String descrip = "HEALPix index at order " + this.k_;
        DefaultValueInfo info = new DefaultValueInfo(name, clazz, descrip);
        info.setUCD("pos.healpix");
        return info;
    }

    @Override
    public long getPositionTile(double ra, double dec) {
        long nestHash = this.hasher_.hash(Math.toRadians(ra), Math.toRadians(dec));
        return this.nest_ ? nestHash : this.hnested_.toRing(nestHash);
    }

    @Override
    public long[] getTileRange(double ra, double dec, double radius) {
        long[] lArray;
        HealpixNestedBMOC bmoc = this.hnested_.newConeComputerApprox(Math.toRadians(radius)).overlappingCells(Math.toRadians(ra), Math.toRadians(dec));
        long lo = Long.MAX_VALUE;
        long hi = Long.MIN_VALUE;
        FlatHashIterator fhit = bmoc.flatHashIterator();
        while (fhit.hasNext()) {
            long hash = fhit.next();
            if (!this.nest_) {
                hash = this.hnested_.toRing(hash);
            }
            lo = Math.min(lo, hash);
            hi = Math.max(hi, hash);
        }
        if (lo <= hi) {
            long[] lArray2 = new long[2];
            lArray2[0] = lo;
            lArray = lArray2;
            lArray2[1] = hi;
        } else {
            lArray = null;
        }
        return lArray;
    }
}

