/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.DataSource;

public class GeojsonTableBuilder
implements TableBuilder {
    private String shapeColName_ = "shape";

    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    public String getFormatName() {
        return "GeoJSON";
    }

    public boolean looksLikeFile(String location) {
        String loc = location.toLowerCase();
        return loc.endsWith(".geojson") || loc.endsWith(".geo-json");
    }

    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storage) throws IOException {
        return this.createStarTable(new BufferedInputStream(datsrc.getInputStream()));
    }

    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        StarTable table = this.createStarTable(in);
        sink.acceptMetadata(table);
        RowSequence rseq = table.getRowSequence();
        while (rseq.next()) {
            sink.acceptRow(rseq.getRow());
        }
        sink.endRows();
    }

    public void setShapeColName(String shapeColName) {
        this.shapeColName_ = shapeColName;
    }

    public String getShapeColName() {
        return this.shapeColName_;
    }

    private StarTable createStarTable(InputStream in) throws IOException {
        JSONObject top;
        try {
            top = new JSONObject(new JSONTokener(in));
        }
        catch (JSONException e) {
            throw new TableFormatException("Not JSON", (Throwable)e);
        }
        finally {
            in.close();
        }
        if ("FeatureCollection".equals(top.get("type"))) {
            JSONArray features = (JSONArray)top.get("features");
            return this.createStarTable(features);
        }
        throw new TableFormatException("No FeatureCollection  in top-level JSON object");
    }

    private StarTable createStarTable(final JSONArray features) {
        int nf = features.length();
        LinkedHashMap<String, Object> propMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < nf; ++i) {
            JSONObject jSONObject;
            JSONObject jobj = features.getJSONObject(i);
            if (!"Feature".equals(jobj.get("type")) || (jSONObject = jobj.getJSONObject("properties")) == null) continue;
            for (String key : jSONObject.keySet()) {
                Object value = jSONObject.get(key);
                propMap.put(key, value);
            }
        }
        ColumnStarTable table = ColumnStarTable.makeTableWithRows((long)nf);
        for (Map.Entry entry : propMap.entrySet()) {
            ColumnData cdata = this.getColumnData(features, (String)entry.getKey(), entry.getValue());
            if (cdata == null) continue;
            table.addColumn(cdata);
        }
        ColumnInfo geomInfo = new ColumnInfo(this.shapeColName_, String.class, "");
        geomInfo.setXtype("stc-s");
        table.addColumn(new ColumnData(geomInfo){

            public Object readValue(long irow) {
                JSONObject geom = features.getJSONObject((int)irow).getJSONObject("geometry");
                String type = geom.getString("type");
                JSONArray coords = geom.getJSONArray("coordinates");
                return GeojsonTableBuilder.this.toStcs(geom.getString("type"), geom.getJSONArray("coordinates"));
            }
        });
        return table;
    }

    private ColumnData getColumnData(final JSONArray features, final String key, Object exampleValue) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = exampleValue == null ? null : exampleValue.getClass();
        if (exampleValue instanceof Number) {
            return new ColumnData(new ColumnInfo(key, Double.class, null)){

                public Object readValue(long irow) {
                    Object value = features.getJSONObject((int)irow).getJSONObject("properties").get(key);
                    if (value instanceof Double) {
                        return value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue();
                    }
                    return null;
                }
            };
        }
        if (exampleValue instanceof String || exampleValue instanceof Boolean) {
            return new ColumnData(new ColumnInfo(key, clazz, null)){

                public Object readValue(long irow) {
                    Object value = features.getJSONObject((int)irow).getJSONObject("properties").get(key);
                    return clazz.isInstance(value) ? value : null;
                }
            };
        }
        return null;
    }

    private String toStcs(String type, JSONArray jsonCoords) {
        if ("MultiPolygon".equals(type)) {
            int npoly = jsonCoords.length();
            StringBuffer sbuf = new StringBuffer();
            if (npoly > 1) {
                sbuf.append("UNION (");
            }
            for (int ip = 0; ip < npoly; ++ip) {
                if (ip > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(this.toStcs("Polygon", jsonCoords.getJSONArray(ip)));
            }
            if (npoly > 1) {
                sbuf.append(")");
            }
            return sbuf.toString();
        }
        if ("Polygon".equals(type)) {
            JSONArray linearRing = jsonCoords.getJSONArray(0);
            int nc = linearRing.length();
            StringBuffer sbuf = new StringBuffer("POLYGON");
            for (int ic = 0; ic < nc - 1; ++ic) {
                JSONArray point = linearRing.getJSONArray(ic);
                sbuf.append(' ').append(point.getDouble(0)).append(' ').append(point.getDouble(1));
            }
            return sbuf.toString();
        }
        return null;
    }
}

