/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.jel.Constant;
import uk.ac.starlink.ttools.jel.FixedConstant;

public abstract class JELRowReader
extends DVMap {
    private final Object[] args_;
    private final List<NamedConstant<?>> constantList_;
    private final Set<Integer> translatedIcols_;
    private boolean isNullExpression_;
    private boolean failOnNull_;
    public static final String NULL_QUERY_PREFIX = "NULL_";
    public static final String OBJECT_PREFIX = "Object$";
    public static final char COLUMN_ID_CHAR = '$';
    private final Constant<Boolean> TRUE_CONST = FixedConstant.createConstant(Boolean.TRUE);
    private final Constant<Boolean> FALSE_CONST = FixedConstant.createConstant(Boolean.FALSE);
    private final Constant<Object> NULL_CONST = new FixedConstant<Object>(null, Object.class);
    private final Constant<Byte> NULL_EXPRESSION_CONST = new Constant<Byte>(){
        private final Byte b0 = 0;

        @Override
        public Class<Byte> getContentClass() {
            return Byte.class;
        }

        @Override
        public Byte getValue() {
            JELRowReader.this.foundNull();
            return this.b0;
        }

        @Override
        public boolean requiresRowIndex() {
            return false;
        }
    };

    public JELRowReader() {
        this.args_ = new Object[]{this};
        this.constantList_ = new ArrayList();
        this.translatedIcols_ = new LinkedHashSet<Integer>();
    }

    public synchronized void setFailOnNull(boolean failOnNull) {
        this.failOnNull_ = failOnNull;
    }

    protected abstract int getColumnIndexByName(String var1);

    protected abstract Constant<?> getConstantByName(String var1);

    protected abstract boolean isBlank(int var1);

    protected abstract Class<?> getColumnClass(int var1);

    protected abstract boolean getBooleanColumnValue(int var1);

    protected abstract byte getByteColumnValue(int var1);

    protected abstract char getCharColumnValue(int var1);

    protected abstract short getShortColumnValue(int var1);

    protected abstract int getIntColumnValue(int var1);

    protected abstract long getLongColumnValue(int var1);

    protected abstract float getFloatColumnValue(int var1);

    protected abstract double getDoubleColumnValue(int var1);

    protected abstract Object getObjectColumnValue(int var1);

    protected void foundNull() {
        this.isNullExpression_ = true;
        if (this.failOnNull_) {
            throw new NullPointerException();
        }
    }

    protected Constant<?> getSpecialByName(String name) {
        if (name.equals("null")) {
            return this.NULL_CONST;
        }
        if (name.equals("NULL")) {
            return this.NULL_EXPRESSION_CONST;
        }
        if (this.getNullConstantIndex(name) >= 0) {
            Object value = this.constantList_.get(this.getNullConstantIndex(name)).getValue();
            return value == null ? this.TRUE_CONST : this.FALSE_CONST;
        }
        return null;
    }

    public synchronized Object evaluate(CompiledExpression compEx) throws Throwable {
        try {
            this.isNullExpression_ = false;
            Object result = compEx.evaluate(this.args_);
            return this.isNullExpression_ ? null : result;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public synchronized boolean evaluateBoolean(CompiledExpression compEx) throws Throwable {
        if (compEx.getType() == 0) {
            try {
                this.isNullExpression_ = false;
                boolean result = compEx.evaluate_boolean(this.args_);
                return this.isNullExpression_ ? false : result;
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return false;
    }

    public synchronized double evaluateDouble(CompiledExpression compEx) throws Throwable {
        try {
            double result;
            this.isNullExpression_ = false;
            switch (compEx.getType()) {
                case 1: {
                    result = compEx.evaluate_byte(this.args_);
                    break;
                }
                case 2: {
                    result = compEx.evaluate_char(this.args_);
                    break;
                }
                case 3: {
                    result = compEx.evaluate_short(this.args_);
                    break;
                }
                case 4: {
                    result = compEx.evaluate_int(this.args_);
                    break;
                }
                case 5: {
                    result = compEx.evaluate_long(this.args_);
                    break;
                }
                case 6: {
                    result = compEx.evaluate_float(this.args_);
                    break;
                }
                case 7: {
                    result = compEx.evaluate_double(this.args_);
                    break;
                }
                default: {
                    return Double.NaN;
                }
            }
            return this.isNullExpression_ ? Double.NaN : result;
        }
        catch (NullPointerException e) {
            return Double.NaN;
        }
    }

    @Override
    public String getTypeName(String name) {
        Class<?> clazz;
        int ispecial = this.getSpecialIndex(name);
        if (ispecial >= 0) {
            return JELRowReader.getTypeName(this.constantList_.get(ispecial).getContentClass());
        }
        int inul = this.getNullColumnIndex(name);
        if (inul >= 0) {
            return "Boolean";
        }
        int icol = this.getColumnIndex(name);
        if (icol >= 0 && (clazz = this.getColumnClass(icol)) != null) {
            return JELRowReader.getTypeName(clazz);
        }
        int iobj = this.getObjectColumnIndex(name);
        if (iobj >= 0) {
            return "Object";
        }
        int inulconst = this.getNullConstantIndex(name);
        if (inulconst >= 0) {
            return "Boolean";
        }
        int iconst = this.getConstantIndex(name);
        if (iconst >= 0) {
            return JELRowReader.getTypeName(this.constantList_.get(iconst).getContentClass());
        }
        return null;
    }

    @Override
    public Object translate(String name) {
        int ispecial = this.getSpecialIndex(name);
        if (ispecial >= 0) {
            return -1 - ispecial;
        }
        int inul = this.getNullColumnIndex(name);
        if (inul >= 0) {
            this.translatedIcols_.add(inul);
            return (long)inul;
        }
        int icol = this.getColumnIndex(name);
        if (icol >= 0) {
            this.translatedIcols_.add(icol);
            return icol;
        }
        int iobj = this.getObjectColumnIndex(name);
        if (iobj >= 0) {
            this.translatedIcols_.add(iobj);
            return iobj;
        }
        int iconst = this.getConstantIndex(name);
        if (iconst >= 0) {
            return -1 - iconst;
        }
        return null;
    }

    public Constant<?>[] getTranslatedConstants() {
        return this.constantList_.stream().map(c -> ((NamedConstant)c).konst_).collect(Collectors.toList()).toArray(new Constant[0]);
    }

    public int[] getTranslatedColumns() {
        int ncol = this.translatedIcols_.size();
        int[] icols = new int[ncol];
        int i = 0;
        for (Integer ic : this.translatedIcols_) {
            icols[i++] = ic;
        }
        assert (i == ncol);
        return icols;
    }

    public final int getColumnIndex(String name) {
        int icol;
        if (name.length() == 0) {
            return -1;
        }
        if (name.charAt(0) == '$') {
            try {
                icol = Integer.parseInt(name.substring(1)) - 1;
                if (icol >= 0) {
                    return icol;
                }
            }
            catch (NumberFormatException icol2) {
                // empty catch block
            }
        }
        if ((icol = this.getColumnIndexByName(name)) >= 0) {
            return icol;
        }
        return -1;
    }

    private int getObjectColumnIndex(String name) {
        return this.getPrefixedColumnIndex(name, OBJECT_PREFIX);
    }

    private int getNullColumnIndex(String name) {
        return this.getPrefixedColumnIndex(name, NULL_QUERY_PREFIX);
    }

    private int getPrefixedColumnIndex(String name, String prefix) {
        String colname = JELRowReader.stripPrefix(name, prefix);
        if (colname != null) {
            return this.getColumnIndex(colname);
        }
        return -1;
    }

    private int getSpecialIndex(String name) {
        for (int i = 0; i < this.constantList_.size(); ++i) {
            String cname = this.constantList_.get(i).getName();
            if (!cname.equals(name)) continue;
            return i;
        }
        Constant<?> konst = this.getSpecialByName(name);
        if (konst != null) {
            this.constantList_.add(JELRowReader.createNamedConstant(name, konst));
            return this.constantList_.size() - 1;
        }
        return -1;
    }

    private int getConstantIndex(String name) {
        int iconst = this.getSpecialIndex(name);
        if (iconst >= 0) {
            return iconst;
        }
        Constant<?> konst = this.getConstantByName(name);
        if (konst != null) {
            this.constantList_.add(JELRowReader.createNamedConstant(name, konst));
            return this.constantList_.size() - 1;
        }
        return -1;
    }

    private int getNullConstantIndex(String name) {
        String constname = JELRowReader.stripPrefix(name, NULL_QUERY_PREFIX);
        if (constname != null) {
            return this.getConstantIndex(constname);
        }
        return -1;
    }

    private Object getConstantValue(int iconst) {
        return this.constantList_.get(iconst).getValue();
    }

    public boolean getBooleanProperty(long inul) {
        return this.isBlank((int)inul);
    }

    public boolean getBooleanProperty(int id) {
        return id >= 0 ? this.getBooleanColumnValue(id) : this.getBooleanValue((Boolean)this.getConstantValue(-1 - id));
    }

    public byte getByteProperty(int id) {
        return id >= 0 ? this.getByteColumnValue(id) : this.getByteValue((Byte)this.getConstantValue(-1 - id));
    }

    public char getCharProperty(int id) {
        return id >= 0 ? this.getCharColumnValue(id) : this.getCharValue((Character)this.getConstantValue(-1 - id));
    }

    public short getShortProperty(int id) {
        return id >= 0 ? this.getShortColumnValue(id) : this.getShortValue((Short)this.getConstantValue(-1 - id));
    }

    public int getIntProperty(int id) {
        return id >= 0 ? this.getIntColumnValue(id) : this.getIntValue((Integer)this.getConstantValue(-1 - id));
    }

    public long getLongProperty(int id) {
        return id >= 0 ? this.getLongColumnValue(id) : this.getLongValue((Long)this.getConstantValue(-1 - id));
    }

    public float getFloatProperty(int id) {
        return id >= 0 ? this.getFloatColumnValue(id) : this.getFloatValue((Float)this.getConstantValue(-1 - id));
    }

    public double getDoubleProperty(int id) {
        return id >= 0 ? this.getDoubleColumnValue(id) : this.getDoubleValue((Double)this.getConstantValue(-1 - id));
    }

    public Object getObjectProperty(int id) {
        return id >= 0 ? this.getObjectColumnValue(id) : this.getConstantValue(-1 - id);
    }

    public Number getNumberProperty(int id) {
        return id >= 0 ? (Number)((Number)this.getObjectColumnValue(id)) : (Number)((Number)this.getConstantValue(-1 - id));
    }

    public String getStringProperty(int id) {
        return id >= 0 ? (String)this.getObjectColumnValue(id) : (String)this.getConstantValue(-1 - id);
    }

    public boolean[] getBooleanArrayProperty(int id) {
        return id >= 0 ? (boolean[])this.getObjectColumnValue(id) : (boolean[])this.getConstantValue(-1 - id);
    }

    public byte[] getByteArrayProperty(int id) {
        return id >= 0 ? (byte[])this.getObjectColumnValue(id) : (byte[])this.getConstantValue(-1 - id);
    }

    public char[] getCharArrayProperty(int id) {
        return id >= 0 ? (char[])this.getObjectColumnValue(id) : (char[])this.getConstantValue(-1 - id);
    }

    public short[] getShortArrayProperty(int id) {
        return id >= 0 ? (short[])this.getObjectColumnValue(id) : (short[])this.getConstantValue(-1 - id);
    }

    public int[] getIntArrayProperty(int id) {
        return id >= 0 ? (int[])this.getObjectColumnValue(id) : (int[])this.getConstantValue(-1 - id);
    }

    public long[] getLongArrayProperty(int id) {
        return id >= 0 ? (long[])this.getObjectColumnValue(id) : (long[])this.getConstantValue(-1 - id);
    }

    public float[] getFloatArrayProperty(int id) {
        return id >= 0 ? (float[])this.getObjectColumnValue(id) : (float[])this.getConstantValue(-1 - id);
    }

    public double[] getDoubleArrayProperty(int id) {
        return id >= 0 ? (double[])this.getObjectColumnValue(id) : (double[])this.getConstantValue(-1 - id);
    }

    public Object[] getObjectArrayProperty(int id) {
        return id >= 0 ? (Object[])this.getObjectColumnValue(id) : (Object[])this.getConstantValue(-1 - id);
    }

    public String[] getStringArrayProperty(int id) {
        return id >= 0 ? (String[])this.getObjectColumnValue(id) : (String[])this.getConstantValue(-1 - id);
    }

    public Date[] getDateArrayProperty(int id) {
        return id >= 0 ? (Date[])this.getObjectColumnValue(id) : (Date[])this.getConstantValue(-1 - id);
    }

    public boolean getBooleanValue(Boolean value) {
        if (value == null) {
            this.foundNull();
            return false;
        }
        return value;
    }

    public byte getByteValue(Byte value) {
        if (value == null) {
            this.foundNull();
            return 0;
        }
        return value;
    }

    public char getCharValue(Character value) {
        if (value == null) {
            this.foundNull();
            return '\u0000';
        }
        return value.charValue();
    }

    public short getShortValue(Short value) {
        if (value == null) {
            this.foundNull();
            return 0;
        }
        return value;
    }

    public int getIntValue(Integer value) {
        if (value == null) {
            this.foundNull();
            return 0;
        }
        return value;
    }

    public long getLongValue(Long value) {
        if (value == null) {
            this.foundNull();
            return 0L;
        }
        return value;
    }

    public float getFloatValue(Float value) {
        return value == null ? Float.NaN : value.floatValue();
    }

    public double getDoubleValue(Double value) {
        return value == null ? Double.NaN : value;
    }

    private static String getTypeName(Class<?> clazz) {
        if (clazz.equals(Boolean.class)) {
            return "Boolean";
        }
        if (clazz.equals(boolean[].class)) {
            return "BooleanArray";
        }
        if (clazz.equals(Byte.class)) {
            return "Byte";
        }
        if (clazz.equals(byte[].class)) {
            return "ByteArray";
        }
        if (clazz.equals(Character.class)) {
            return "Char";
        }
        if (clazz.equals(char[].class)) {
            return "CharArray";
        }
        if (clazz.equals(Short.class)) {
            return "Short";
        }
        if (clazz.equals(short[].class)) {
            return "ShortArray";
        }
        if (clazz.equals(Integer.class)) {
            return "Int";
        }
        if (clazz.equals(int[].class)) {
            return "IntArray";
        }
        if (clazz.equals(Long.class)) {
            return "Long";
        }
        if (clazz.equals(long[].class)) {
            return "LongArray";
        }
        if (clazz.equals(Float.class)) {
            return "Float";
        }
        if (clazz.equals(float[].class)) {
            return "FloatArray";
        }
        if (clazz.equals(Double.class)) {
            return "Double";
        }
        if (clazz.equals(double[].class)) {
            return "DoubleArray";
        }
        if (clazz.equals(Number.class)) {
            return "Number";
        }
        if (clazz.equals(String.class)) {
            return "String";
        }
        if (clazz.equals(String[].class)) {
            return "StringArray";
        }
        if (clazz.equals(Date.class)) {
            return "Date";
        }
        if (clazz.equals(Date[].class)) {
            return "DateArray";
        }
        if (clazz.getComponentType() != null) {
            return "ObjectArray";
        }
        return "Object";
    }

    public static String stripPrefix(String name, String prefix) {
        if (name != null && name.length() > prefix.length() && name.toLowerCase().startsWith(prefix.toLowerCase())) {
            return name.substring(prefix.length());
        }
        return null;
    }

    private static <T> NamedConstant<T> createNamedConstant(String name, Constant<T> konst) {
        return new NamedConstant<T>(name, konst);
    }

    private static class NamedConstant<T> {
        private final String name_;
        private final Constant<T> konst_;

        NamedConstant(String name, Constant<T> konst) {
            this.name_ = name;
            this.konst_ = konst;
        }

        public String getName() {
            return this.name_;
        }

        public Class<T> getContentClass() {
            return this.konst_.getContentClass();
        }

        public T getValue() {
            return this.konst_.getValue();
        }
    }
}

