/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import java.io.IOException;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;

public class SequentialJELRowReader
extends StarTableJELRowReader
implements RowSequence {
    private final RowSequence rseq_;
    private final LongSupplier rowIndex_;
    private long lrow_;

    public SequentialJELRowReader(StarTable table) throws IOException {
        super(table);
        this.rseq_ = table.getRowSequence();
        this.rowIndex_ = () -> this.lrow_;
        this.lrow_ = -1L;
    }

    public SequentialJELRowReader(StarTable table, RowSplittable rsplit) {
        super(table);
        this.rseq_ = rsplit;
        this.rowIndex_ = rsplit.rowIndex();
        this.lrow_ = Long.MIN_VALUE;
    }

    @Override
    public Object getCell(int icol) throws IOException {
        return this.rseq_.getCell(icol);
    }

    public Object[] getRow() throws IOException {
        return this.rseq_.getRow();
    }

    public boolean next() throws IOException {
        ++this.lrow_;
        return this.rseq_.next();
    }

    @Override
    public long getCurrentRow() {
        if (this.rowIndex_ != null) {
            return this.rowIndex_.getAsLong();
        }
        throw new RuntimeException("Reader does not know row index");
    }

    public void close() throws IOException {
        this.rseq_.close();
    }
}

