/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.jel.Constant;
import uk.ac.starlink.ttools.jel.JELRowReader;

public abstract class StarTableJELRowReader
extends JELRowReader {
    private final StarTable table_;
    private Map<String, ColMeta> colMetaMap_;
    private static final AtomicInteger seeder_ = new AtomicInteger();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.jel");
    public static final String PARAM_PREFIX = "param$";
    public static final String UCD_PREFIX = "ucd$";
    public static final String UTYPE_PREFIX = "utype$";

    public StarTableJELRowReader(StarTable table) {
        this.table_ = table;
    }

    public StarTable getTable() {
        return this.table_;
    }

    protected abstract Object getCell(int var1) throws IOException;

    public abstract long getCurrentRow();

    public boolean requiresRowIndex() {
        for (Constant<?> konst : this.getTranslatedConstants()) {
            if (!konst.requiresRowIndex()) continue;
            return true;
        }
        return false;
    }

    public double valueDouble(String colName) {
        Object value;
        ColMeta colMeta = this.getColMetaByExactName(colName);
        if (colMeta != null && colMeta.isNumber_ && (value = this.getCellValue(colMeta.icol_)) instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.NaN;
    }

    public int valueInt(String colName) {
        Number num;
        Object value;
        ColMeta colMeta = this.getColMetaByExactName(colName);
        if (colMeta != null && colMeta.isNumber_ && (value = this.getCellValue(colMeta.icol_)) instanceof Number && Double.isFinite((num = (Number)value).doubleValue())) {
            return num.intValue();
        }
        this.foundNull();
        return 0;
    }

    public long valueLong(String colName) {
        Number num;
        Object value;
        ColMeta colMeta = this.getColMetaByExactName(colName);
        if (colMeta != null && colMeta.isNumber_ && (value = this.getCellValue(colMeta.icol_)) instanceof Number && Double.isFinite((num = (Number)value).doubleValue())) {
            return num.longValue();
        }
        this.foundNull();
        return 0L;
    }

    public String valueString(String colName) {
        Object value;
        ColMeta colMeta = this.getColMetaByExactName(colName);
        if (colMeta != null && (value = this.getCellValue(colMeta.icol_)) != null) {
            return value.toString();
        }
        return null;
    }

    public Object valueObject(String colName) {
        ColMeta colMeta = this.getColMetaByExactName(colName);
        if (colMeta != null) {
            return this.getCellValue(colMeta.icol_);
        }
        return null;
    }

    @Override
    protected boolean isBlank(int icol) {
        try {
            return Tables.isBlank((Object)this.getCell(icol));
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    @Override
    protected Class<?> getColumnClass(int icol) {
        return icol < this.table_.getColumnCount() ? this.table_.getColumnInfo(icol).getContentClass() : null;
    }

    @Override
    protected int getColumnIndexByName(String name) {
        String utypeSpec;
        int icol;
        ColumnInfo[] colInfos = Tables.getColumnInfos((StarTable)this.table_);
        int ncol = colInfos.length;
        String ucdSpec = StarTableJELRowReader.stripPrefix(name, UCD_PREFIX);
        if (ucdSpec != null) {
            Pattern ucdRegex = StarTableJELRowReader.getUcdRegex(ucdSpec);
            for (icol = 0; icol < ncol; ++icol) {
                String ucd = colInfos[icol].getUCD();
                if (ucd == null || !ucdRegex.matcher(ucd).matches()) continue;
                return icol;
            }
        }
        if ((utypeSpec = StarTableJELRowReader.stripPrefix(name, UTYPE_PREFIX)) != null) {
            Pattern utypeRegex = StarTableJELRowReader.getUtypeRegex(utypeSpec);
            for (int icol2 = 0; icol2 < ncol; ++icol2) {
                String utype = colInfos[icol2].getUtype();
                if (utype == null || !utypeRegex.matcher(utype).matches()) continue;
                return icol2;
            }
        }
        for (icol = 0; icol < ncol; ++icol) {
            if (!colInfos[icol].getName().equals(name)) continue;
            return icol;
        }
        for (icol = 0; icol < ncol; ++icol) {
            if (!colInfos[icol].getName().equalsIgnoreCase(name)) continue;
            return icol;
        }
        return -1;
    }

    public DescribedValue getDescribedValueByName(String name) {
        List paramList = this.table_.getParameters();
        String ucdSpec = StarTableJELRowReader.stripPrefix(name, UCD_PREFIX);
        if (ucdSpec != null) {
            Pattern ucdRegex = StarTableJELRowReader.getUcdRegex(ucdSpec);
            for (DescribedValue dval : paramList) {
                String ucd = dval.getInfo().getUCD();
                if (ucd == null || !ucdRegex.matcher(ucd).matches()) continue;
                return dval;
            }
            return null;
        }
        String utypeSpec = StarTableJELRowReader.stripPrefix(name, UTYPE_PREFIX);
        if (utypeSpec != null) {
            Pattern utypeRegex = StarTableJELRowReader.getUtypeRegex(utypeSpec);
            for (DescribedValue dval : paramList) {
                String utype = dval.getInfo().getUtype();
                if (utype == null || !utypeRegex.matcher(utype).matches()) continue;
                return dval;
            }
            return null;
        }
        String pname = StarTableJELRowReader.stripPrefix(name, PARAM_PREFIX);
        if (pname != null) {
            for (DescribedValue dval : paramList) {
                if (!pname.equals(dval.getInfo().getName())) continue;
                return dval;
            }
            for (DescribedValue dval : paramList) {
                if (!pname.equalsIgnoreCase(dval.getInfo().getName())) continue;
                return dval;
            }
            return null;
        }
        return null;
    }

    @Override
    protected Constant<?> getConstantByName(String name) {
        DescribedValue dval = this.getDescribedValueByName(name);
        if (dval != null) {
            return this.createDescribedValueConstant(dval);
        }
        if (name.equalsIgnoreCase("$nrow")) {
            return new Constant<Long>(){

                @Override
                public Class<Long> getContentClass() {
                    return Long.class;
                }

                @Override
                public Long getValue() {
                    return StarTableJELRowReader.this.table_.getRowCount();
                }

                @Override
                public boolean requiresRowIndex() {
                    return false;
                }
            };
        }
        if (name.equalsIgnoreCase("$ncol")) {
            return new Constant<Integer>(){

                @Override
                public Class<Integer> getContentClass() {
                    return Integer.class;
                }

                @Override
                public Integer getValue() {
                    int ncol = StarTableJELRowReader.this.table_.getColumnCount();
                    return ncol >= 0 ? Integer.valueOf(ncol) : null;
                }

                @Override
                public boolean requiresRowIndex() {
                    return false;
                }
            };
        }
        return null;
    }

    @Override
    protected Constant<?> getSpecialByName(String name) {
        if (name.equals("$0") || name.equalsIgnoreCase("Index") || name.equalsIgnoreCase("$index")) {
            return new Constant<Long>(){

                @Override
                public Class<Long> getContentClass() {
                    return Long.class;
                }

                @Override
                public Long getValue() {
                    return StarTableJELRowReader.this.getCurrentRow() + 1L;
                }

                @Override
                public boolean requiresRowIndex() {
                    return true;
                }
            };
        }
        if (name.equalsIgnoreCase("$random") || name.equals("RANDOM")) {
            final long seed0 = seeder_.incrementAndGet() * -2323;
            return new Constant<Double>(){

                @Override
                public Class<Double> getContentClass() {
                    return Double.class;
                }

                @Override
                public Double getValue() {
                    long seed = seed0 + StarTableJELRowReader.this.getCurrentRow() * 2000000011L;
                    return new Random(seed).nextDouble();
                }

                @Override
                public boolean requiresRowIndex() {
                    return true;
                }
            };
        }
        return super.getSpecialByName(name);
    }

    protected Constant<?> createDescribedValueConstant(DescribedValue dval) {
        Object val = dval.getValue();
        return StarTableJELRowReader.createConstant(dval.getInfo().getContentClass(), Tables.isBlank((Object)val) ? null : val);
    }

    private static <T> Constant<T> createConstant(final Class<T> clazz, Object objValue) {
        final T value = clazz.cast(objValue);
        return new Constant<T>(){

            @Override
            public Class<T> getContentClass() {
                return clazz;
            }

            @Override
            public T getValue() {
                return value;
            }

            @Override
            public boolean requiresRowIndex() {
                return false;
            }
        };
    }

    @Override
    protected boolean getBooleanColumnValue(int icol) {
        return this.getBooleanValue((Boolean)this.getCellValue(icol));
    }

    @Override
    protected byte getByteColumnValue(int icol) {
        return this.getByteValue((Byte)this.getCellValue(icol));
    }

    @Override
    protected char getCharColumnValue(int icol) {
        return this.getCharValue((Character)this.getCellValue(icol));
    }

    @Override
    protected short getShortColumnValue(int icol) {
        return this.getShortValue((Short)this.getCellValue(icol));
    }

    @Override
    protected int getIntColumnValue(int icol) {
        return this.getIntValue((Integer)this.getCellValue(icol));
    }

    @Override
    protected long getLongColumnValue(int icol) {
        return this.getLongValue((Long)this.getCellValue(icol));
    }

    @Override
    protected float getFloatColumnValue(int icol) {
        return this.getFloatValue((Float)this.getCellValue(icol));
    }

    @Override
    protected double getDoubleColumnValue(int icol) {
        return this.getDoubleValue((Double)this.getCellValue(icol));
    }

    @Override
    protected Object getObjectColumnValue(int icol) {
        return this.getCellValue(icol);
    }

    private Object getCellValue(int icol) {
        try {
            return this.getCell(icol);
        }
        catch (IOException e) {
            logger_.warning("Expression evaluation error: " + e);
            return null;
        }
    }

    private ColMeta getColMetaByExactName(String name) {
        if (this.colMetaMap_ == null) {
            HashMap<String, ColMeta> map = new HashMap<String, ColMeta>();
            int ncol = this.table_.getColumnCount();
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo info = this.table_.getColumnInfo(icol);
                map.put(info.getName(), new ColMeta(icol, info.getContentClass()));
            }
            this.colMetaMap_ = map;
        }
        return this.colMetaMap_.get(name);
    }

    public static Pattern getUcdRegex(String ucd) {
        String regex = ucd.replaceAll("[_\\W]", "\\[_\\\\W\\]");
        if (regex.endsWith("[_\\W]")) {
            regex = regex.substring(0, regex.length() - 5) + ".*";
        }
        return Pattern.compile(regex, 2);
    }

    public static Pattern getUtypeRegex(String utype) {
        String regex = utype.replaceAll("_", "\\\\W");
        return Pattern.compile(regex, 2);
    }

    private static class ColMeta {
        final int icol_;
        final boolean isNumber_;
        final boolean isString_;

        ColMeta(int icol, Class<?> clazz) {
            this.icol_ = icol;
            this.isNumber_ = Number.class.isAssignableFrom(clazz);
            this.isString_ = String.class.equals(clazz);
        }
    }
}

