/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Rectangle;
import java.util.BitSet;
import uk.ac.starlink.ttools.plot.Pixellator;

public class BitSetPixellator
implements Pixellator {
    private final Rectangle bounds_;
    private final BitSet mask_;
    private int iNext_ = -2;
    private int x_;
    private int y_;

    public BitSetPixellator(Rectangle bounds, BitSet mask) {
        this.bounds_ = bounds;
        this.mask_ = mask;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.bounds_);
    }

    @Override
    public void start() {
        this.iNext_ = -1;
    }

    @Override
    public boolean next() {
        int in = this.mask_.nextSetBit(this.iNext_ + 1);
        if (in >= 0) {
            this.x_ = in % this.bounds_.width + this.bounds_.x;
            this.y_ = in / this.bounds_.width + this.bounds_.y;
            this.iNext_ = in;
            return true;
        }
        this.x_ = Integer.MIN_VALUE;
        this.y_ = Integer.MIN_VALUE;
        return false;
    }

    @Override
    public int getX() {
        return this.x_;
    }

    @Override
    public int getY() {
        return this.y_;
    }

    public static BitSetPixellator copy(Pixellator pixer) {
        Rectangle bounds = pixer.getBounds();
        BitSet bitmap = new BitSet(bounds.width * bounds.height);
        pixer.start();
        while (pixer.next()) {
            int x = pixer.getX();
            int y = pixer.getY();
            bitmap.set(x - bounds.x + bounds.width * (y - bounds.y));
        }
        return new BitSetPixellator(bounds, bitmap);
    }
}

