/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.GangContext;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;

public class SingleGangerFactory<P, A>
implements GangerFactory<P, A> {
    private static final SingleGangerFactory INSTANCE = new SingleGangerFactory();

    private SingleGangerFactory() {
    }

    @Override
    public boolean hasIndependentZones() {
        return false;
    }

    @Override
    public ConfigKey<?>[] getGangerKeys() {
        return new ConfigKey[0];
    }

    @Override
    public Ganger<P, A> createGanger(Padding padding, ConfigMap config, GangContext context) {
        return new SingleGanger(padding);
    }

    public static <P, A> SingleGangerFactory<P, A> instance() {
        return INSTANCE;
    }

    public static <P, A> Ganger<P, A> createGanger(Padding padding) {
        return new SingleGanger(padding);
    }

    public static <P, A> Ganger<P, A> createGanger() {
        return SingleGangerFactory.createGanger(null);
    }

    private static class SingleGang
    implements Gang {
        private final Rectangle plotBounds_;

        SingleGang(Rectangle plotBounds) {
            this.plotBounds_ = new Rectangle(plotBounds);
        }

        @Override
        public int getZoneCount() {
            return 1;
        }

        public Rectangle getGangPlotBounds() {
            return this.plotBounds_;
        }

        @Override
        public Rectangle getZonePlotBounds(int iz) {
            if (iz == 0) {
                return this.plotBounds_;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getNavigationZoneIndex(Point pos) {
            return 0;
        }
    }

    private static class SingleGanger<P, A>
    implements Ganger<P, A> {
        private final Padding padding_;

        public SingleGanger(Padding padding) {
            this.padding_ = padding;
        }

        @Override
        public int getZoneCount() {
            return 1;
        }

        @Override
        public boolean isTrimmingGlobal() {
            return false;
        }

        @Override
        public boolean isShadingGlobal() {
            return false;
        }

        @Override
        public Gang createGang(Rectangle[] zonePlotBounds) {
            if (zonePlotBounds.length == 1) {
                return new SingleGang(zonePlotBounds[0]);
            }
            throw new IllegalArgumentException("Zone count not 1");
        }

        @Override
        public Gang createGang(Rectangle extBounds, SurfaceFactory<P, A> surfFact, ZoneContent<P, A>[] contents, Trimming[] trimmings, ShadeAxis[] shadeAxes, boolean withScroll) {
            ZoneContent<P, A> content = contents[0];
            Rectangle plotBounds = PlotPlacement.calculateDataBounds(extBounds, this.padding_, surfFact, content.getProfile(), content.getAspect(), withScroll, trimmings[0], shadeAxes[0]);
            return new SingleGang(plotBounds);
        }

        @Override
        public Gang createApproxGang(Rectangle extBounds) {
            Insets insets = Padding.padInsets(this.padding_, new Insets(0, 0, 0, 0));
            Rectangle plotBounds = PlotUtil.subtractInsets(extBounds, insets);
            return new SingleGang(plotBounds);
        }

        @Override
        public A[] adjustAspects(A[] oldAspects, int iz) {
            return oldAspects;
        }

        @Override
        public P[] adjustProfiles(P[] oldProfiles) {
            return oldProfiles;
        }
    }
}

