/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.ColorConfigKey;
import uk.ac.starlink.ttools.plot2.config.NamedColorChooserPanel;
import uk.ac.starlink.ttools.plot2.config.NamedColorSet;
import uk.ac.starlink.ttools.plot2.config.PaletteColorChooserPanel;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;

public class ChooserColorSpecifier
extends SpecifierPanel<Color> {
    private final JColorChooser chooser_;
    private final Action chooserAct_;
    private final ChooseAction okAct_;
    private final ChooseAction resetAct_;
    private Color color_;
    private static final Map<String, Color[]> PALETTE_MAP = ChooserColorSpecifier.createPaletteMap();
    private static final Map<String, Color> COLOR_MAP = NamedColorSet.CSS_DARK.getMap();

    public ChooserColorSpecifier(Color dfltColor) {
        this(new JColorChooser(dfltColor));
        AbstractColorChooserPanel[] extraChoosers;
        for (AbstractColorChooserPanel c : extraChoosers = new AbstractColorChooserPanel[]{new PaletteColorChooserPanel(PALETTE_MAP, this.chooser_), new NamedColorChooserPanel(COLOR_MAP, this.chooser_)}) {
            this.chooser_.addChooserPanel(c);
        }
        this.chooser_.setPreviewPanel(new JPanel());
    }

    public ChooserColorSpecifier(JColorChooser chooser) {
        super(false);
        this.chooser_ = chooser;
        this.okAct_ = new ChooseAction("OK");
        this.resetAct_ = new ChooseAction("Reset");
        final JPopupMenu popup = new JPopupMenu("JColorChooser");
        popup.insert(this.chooser_, 0);
        popup.add(this.okAct_.createMenuItem());
        popup.add(this.resetAct_.createMenuItem());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ChooserColorSpecifier.this.resetAct_.setActionColor(ChooserColorSpecifier.this.color_);
                ChooserColorSpecifier.this.okAct_.setActionColor(ChooserColorSpecifier.this.chooser_.getColor());
            }
        });
        this.chooser_.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Color color = ChooserColorSpecifier.this.chooser_.getColor();
                ChooserColorSpecifier.this.okAct_.setActionColor(color);
                ChooserColorSpecifier.this.setSpecifiedValue(color);
            }
        });
        this.chooserAct_ = new AbstractAction("Color", ResourceIcon.COLOR_WHEEL){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object src = evt.getSource();
                Component c = src instanceof Component ? (Component)src : null;
                popup.show(c, 0, 0);
            }
        };
        this.chooserAct_.putValue("ShortDescription", "Free colour chooser");
    }

    @Override
    protected JComponent createComponent() {
        JButton button = new JButton(this.chooserAct_);
        button.setHideActionText(true);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    @Override
    public Color getSpecifiedValue() {
        return this.color_;
    }

    @Override
    public void setSpecifiedValue(Color color) {
        this.color_ = color;
        this.fireAction();
    }

    @Override
    public void submitReport(ReportMap report) {
    }

    public JColorChooser getColorChooser() {
        return this.chooser_;
    }

    public static Map<String, Color[]> createPaletteMap() {
        LinkedHashMap<String, Color[]> map = new LinkedHashMap<String, Color[]>();
        map.put("Classic", ColorConfigKey.getPlottingColors());
        map.put("Cycle1", ChooserColorSpecifier.toColors(new int[]{0xFF0000, 255, 32768, 0xC0C000, 0xC000C0, 49344, 0x404040}));
        map.put("Cycle2", new Color[]{new Color(0.635f, 0.078f, 0.184f), new Color(0.0f, 0.447f, 0.741f), new Color(0.466f, 0.674f, 0.188f), new Color(0.929f, 0.694f, 0.125f), new Color(0.494f, 0.184f, 0.556f), new Color(0.301f, 0.745f, 0.933f), new Color(0.85f, 0.325f, 0.098f)});
        map.put("SRON-Bright", ChooserColorSpecifier.toColors(new int[]{0xEE3333, 0x3366AA, 0x66AA55, 0xCCCC55, 0x992288, 0x11AA99, 0xEE7722}));
        map.put("SRON-Light", ChooserColorSpecifier.toColors(new int[]{0x77AADD, 0x77CCCC, 0x88CCAA, 0xDDDD77, 0xDDAA77, 0xDD7788, 0xCC99BB}));
        map.put("SRON-Mid", ChooserColorSpecifier.toColors(new int[]{0x4477AA, 0x44AAAA, 0x44AA77, 0xAAAA44, 0xAA7744, 0xAA4455, 0xAA4488}));
        map.put("SRON-Dark", ChooserColorSpecifier.toColors(new int[]{0x114477, 0x117777, 0x117744, 0x777711, 0x774411, 0x771122, 0x771155}));
        return Collections.unmodifiableMap(map);
    }

    private static Color[] toColors(int[] rgbs) {
        int nc = rgbs.length;
        Color[] colors = new Color[nc];
        for (int ic = 0; ic < nc; ++ic) {
            colors[ic] = new Color(rgbs[ic], false);
        }
        return colors;
    }

    private static abstract class PreviewIcon
    implements Icon {
        private final int iconHeight_;
        private final int iconWidth_;
        private final Color disabledColor_;
        private final Font hexFont_;
        private final int gap_;
        private final int blockWidth_;
        private final int shadeWidth_;
        private final Shader[] shaders_;
        private final int markWidth_;
        private final int[] sizes_;
        private final int txtWidth_;
        private final int padTxt_;
        private final int yTxt_;

        PreviewIcon(int height) {
            this.iconHeight_ = height;
            this.blockWidth_ = 24;
            this.gap_ = 10;
            this.shadeWidth_ = 20;
            this.shaders_ = new Shader[]{Shaders.invert(Shaders.FADE_BLACK), Shaders.FADE_WHITE};
            this.markWidth_ = 10;
            this.sizes_ = new int[]{0, 1, 2, 3, 2, 1, 0};
            Color dcol = UIManager.getColor("Label.disabledForeground");
            this.disabledColor_ = dcol == null ? Color.GRAY : dcol;
            this.hexFont_ = new Font("Monospaced", 0, 12);
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
            String hex0 = this.getHexString(Color.BLACK);
            this.txtWidth_ = this.hexFont_.getStringBounds((String)hex0, (FontRenderContext)frc).getBounds().width;
            LineMetrics lm = this.hexFont_.getLineMetrics(hex0, frc);
            this.yTxt_ = (int)(lm.getHeight() + lm.getLeading());
            this.padTxt_ = 4;
            this.iconWidth_ = this.blockWidth_ + this.gap_ + this.shadeWidth_ * this.shaders_.length + this.gap_ + this.markWidth_ * this.sizes_.length + this.gap_ + this.txtWidth_ + 2 * this.padTxt_ + this.gap_;
        }

        protected abstract Color getPreviewColor();

        @Override
        public int getIconWidth() {
            return this.iconWidth_;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color0 = g.getColor();
            Font font0 = g.getFont();
            Color color = c.isEnabled() ? this.getPreviewColor() : this.disabledColor_;
            g.setColor(color);
            g.fillRect(x, y, this.blockWidth_, this.iconHeight_);
            x += this.blockWidth_ + this.gap_;
            for (Shader sh : this.shaders_) {
                Shaders.createShaderIcon(Shaders.applyShader(sh, color, this.shadeWidth_), true, this.shadeWidth_, this.iconHeight_, 0, 0).paintIcon(c, g, x, y);
                x += this.shadeWidth_;
            }
            g.setColor(Color.WHITE);
            g.fillRect(x += this.gap_, y, this.sizes_.length * this.markWidth_, this.iconHeight_);
            for (int i = 0; i < this.sizes_.length; ++i) {
                MarkerShape.FILLED_CIRCLE.getStyle(color, this.sizes_[i]).getLegendIcon(this.markWidth_, this.iconHeight_).paintIcon(c, g, x, y);
                x += this.markWidth_;
            }
            g.setColor(Color.WHITE);
            g.fillRect(x += this.gap_, y, this.txtWidth_ + 2 * this.padTxt_, this.iconHeight_);
            g.setFont(this.hexFont_);
            g.setColor(color);
            g.drawString(this.getHexString(color), x + this.padTxt_, this.yTxt_);
            x += this.txtWidth_ + 2 * this.padTxt_;
            g.setFont(font0);
            g.setColor(color0);
        }

        private String getHexString(Color color) {
            String hex = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
            for (int i = hex.length(); i < 6; ++i) {
                hex = "0" + hex;
            }
            return hex;
        }
    }

    private class ChooseAction
    extends AbstractAction {
        private static final String COLOR_PROP = "colorChoice";

        ChooseAction(String name) {
            super(name);
            this.putValue("SmallIcon", new PreviewIcon(12){

                @Override
                protected Color getPreviewColor() {
                    return ChooseAction.this.getActionColor();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ChooserColorSpecifier.this.setSpecifiedValue(this.getActionColor());
        }

        void setActionColor(Color color) {
            this.putValue(COLOR_PROP, color);
        }

        Color getActionColor() {
            Object color = this.getValue(COLOR_PROP);
            return color instanceof Color ? (Color)color : null;
        }

        JMenuItem createMenuItem() {
            final JMenuItem mItem = new JMenuItem(this);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ChooseAction.COLOR_PROP.equals(evt.getPropertyName())) {
                        mItem.repaint();
                    }
                }
            });
            return mItem;
        }
    }
}

